/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation.facade;

import io.github.slimjar.exceptions.RelocatorException;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.relocation.facade.JarRelocatorFacade;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReflectiveJarRelocatorFacade
implements JarRelocatorFacade {
    @NotNull
    private final Object relocator;
    @NotNull
    private final Method relocatorRunMethod;

    ReflectiveJarRelocatorFacade(@NotNull Object relocator, @NotNull Method relocatorRunMethod) {
        this.relocator = relocator;
        this.relocatorRunMethod = relocatorRunMethod;
    }

    @Override
    public void run() throws RelocatorException {
        try {
            this.relocatorRunMethod.invoke(this.relocator, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException err) {
            throw new RelocatorException("Unable to invoke relocator.", err);
        }
    }
}

