/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation;

import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public record RelocationRule(@NotNull String originalPackagePattern, @NotNull String relocatedPackagePattern, @NotNull Collection<String> exclusions, @NotNull Collection<String> inclusions) {
    public RelocationRule(@NotNull String original, @NotNull String relocated) {
        this(original, relocated, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelocationRule)) {
            return false;
        }
        RelocationRule that = (RelocationRule)o;
        return this.originalPackagePattern.equals(that.originalPackagePattern) && this.relocatedPackagePattern.equals(that.relocatedPackagePattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.originalPackagePattern, this.relocatedPackagePattern);
    }

    @Override
    public String toString() {
        return "RelocationRule{originalPackagePattern='" + this.originalPackagePattern + "', relocatedPackagePattern='" + this.relocatedPackagePattern + "'}";
    }
}

