/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation;

import io.github.slimjar.exceptions.RelocatorException;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.relocation.Relocator;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public final class PassthroughRelocator
implements Relocator {
    @Override
    public void relocate(@NotNull File input, @NotNull File output) throws RelocatorException {
        if (input.equals(output)) {
            return;
        }
        if (output.exists()) {
            return;
        }
        try {
            Files.copy(input.toPath(), output.toPath(), new CopyOption[0]);
        }
        catch (IOException err) {
            throw new RelocatorException("Failed to copy to %s".formatted(output), err);
        }
    }
}

