/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation;

import io.github.slimjar.exceptions.RelocatorException;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.relocation.RelocationRule;
import io.github.slimjar.relocation.Relocator;
import io.github.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public final class JarFileRelocator
implements Relocator {
    @NotNull
    private final Collection<RelocationRule> relocations;
    @NotNull
    private final JarRelocatorFacadeFactory relocatorFacadeFactory;

    public JarFileRelocator(@NotNull Collection<RelocationRule> relocations, @NotNull JarRelocatorFacadeFactory relocatorFacadeFactory) {
        this.relocations = relocations;
        this.relocatorFacadeFactory = relocatorFacadeFactory;
    }

    @Override
    public void relocate(@NotNull File input, @NotNull File output) throws RelocatorException {
        output.getParentFile().mkdirs();
        try {
            output.createNewFile();
            this.relocatorFacadeFactory.createFacade(input, output, this.relocations).run();
        }
        catch (IOException err) {
            throw new RelocatorException("Unable to create new file during relocation.", err);
        }
    }
}

