/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.loader;

import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.injector.loader.Injectable;
import io.github.slimjar.libs.annotations.NotNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public final class WrappedInjectableClassLoader
implements Injectable {
    @NotNull
    private final URLClassLoader urlClassLoader;
    @NotNull
    private final Method addURLMethod;

    public WrappedInjectableClassLoader(@NotNull URLClassLoader urlClassLoader) throws InjectorException {
        this.urlClassLoader = urlClassLoader;
        try {
            this.addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        }
        catch (NoSuchMethodException err) {
            throw new InjectorException("Unable to find addURL method", err);
        }
    }

    @Override
    public void inject(@NotNull URL url) throws InjectorException {
        this.addURLMethod.setAccessible(true);
        try {
            this.addURLMethod.invoke((Object)this.urlClassLoader, url);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InjectorException("Unable to invoke addURL method", e);
        }
    }
}

