/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.loader;

import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.injector.loader.Injectable;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import sun.misc.Unsafe;

public final class UnsafeInjectable
implements Injectable {
    @NotNull
    private final ArrayDeque<URL> unopenedURLs;
    @NotNull
    private final ArrayList<URL> pathURLs;

    public UnsafeInjectable(@NotNull ArrayDeque<URL> unopenedURLs, @NotNull ArrayList<URL> pathURLs) {
        this.unopenedURLs = unopenedURLs;
        this.pathURLs = pathURLs;
    }

    @Override
    public void inject(@NotNull URL url) throws InjectorException {
        this.unopenedURLs.addLast(url);
        this.pathURLs.add(url);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Injectable create(@NotNull URLClassLoader classLoader) throws InjectorException {
        ArrayList pathURLs;
        ArrayDeque unopenedURLs;
        Unsafe unsafe = Unsafe.getUnsafe();
        try {
            Object ucp = UnsafeInjectable.fetchField(unsafe, URLClassLoader.class, classLoader, "ucp");
            unopenedURLs = (ArrayDeque)UnsafeInjectable.fetchField(unsafe, ucp, "unopenedUrls");
            pathURLs = (ArrayList)UnsafeInjectable.fetchField(unsafe, ucp, "path");
        }
        catch (NoSuchFieldException err) {
            throw new InjectorException("Unable to fetch fields.", err);
        }
        return new UnsafeInjectable(unopenedURLs, pathURLs);
    }

    private static Object fetchField(Unsafe unsafe, Object object, String name) throws NoSuchFieldException {
        return UnsafeInjectable.fetchField(unsafe, object.getClass(), object, name);
    }

    @NotNull
    private static Object fetchField(@NotNull Unsafe unsafe, @NotNull Class<?> clazz, @NotNull Object object, @NotNull String name) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(name);
        long offset = unsafe.objectFieldOffset(field);
        return unsafe.getObject(object, offset);
    }
}

