/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.loader;

import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.exceptions.RelocatorException;
import io.github.slimjar.injector.agent.ByteBuddyInstrumentationFactory;
import io.github.slimjar.injector.agent.InstrumentationFactory;
import io.github.slimjar.injector.loader.Injectable;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import io.github.slimjar.relocation.facade.ReflectiveJarRelocatorFacadeFactory;
import io.github.slimjar.resolver.data.Repository;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.jar.JarFile;

public final class InstrumentationInjectable
implements Injectable {
    @NotNull
    private final Instrumentation instrumentation;

    public InstrumentationInjectable(@NotNull Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    @Override
    public void inject(@NotNull URL url) throws InjectorException {
        try {
            this.instrumentation.appendToSystemClassLoaderSearch(new JarFile(new File(url.toURI())));
        }
        catch (IOException | URISyntaxException e) {
            throw new InjectorException("Failed to inject %s into classLoader.".formatted(url), e);
        }
    }

    @NotNull
    public static Injectable create(@NotNull Path downloadPath, @NotNull Collection<Repository> repositories) throws InjectorException {
        JarRelocatorFacadeFactory jarRelocatorFacadeFactory;
        try {
            jarRelocatorFacadeFactory = ReflectiveJarRelocatorFacadeFactory.create(downloadPath, repositories);
        }
        catch (RelocatorException err) {
            throw new InjectorException("Failed to create relocator facade factory.", err);
        }
        return InstrumentationInjectable.create(new ByteBuddyInstrumentationFactory(jarRelocatorFacadeFactory));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Injectable create(@NotNull InstrumentationFactory factory) throws InjectorException {
        return new InstrumentationInjectable(factory.create());
    }
}

