/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.loader;

import io.github.slimjar.app.builder.ApplicationBuilder;
import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.injector.loader.Injectable;
import io.github.slimjar.injector.loader.InstrumentationInjectable;
import io.github.slimjar.injector.loader.UnsafeInjectable;
import io.github.slimjar.injector.loader.WrappedInjectableClassLoader;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.data.Repository;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Supplier;

public final class InjectableFactory {
    private InjectableFactory() {
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Injectable create(@NotNull Path downloadPath, @NotNull Collection<Repository> repositories) throws InjectorException {
        return InjectableFactory.create(downloadPath, repositories, InjectableFactory.class.getClassLoader());
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static Injectable create(@NotNull Path downloadPath, @NotNull Collection<Repository> repositories, @NotNull ClassLoader classLoader) throws InjectorException {
        Supplier<Injectable> injector = () -> InstrumentationInjectable.create(downloadPath, repositories);
        if (!(classLoader instanceof URLClassLoader)) {
            return injector.get();
        }
        URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
        if (InjectableFactory.isJigsawActive()) {
            return new WrappedInjectableClassLoader((URLClassLoader)ApplicationBuilder.class.getClassLoader());
        }
        if (InjectableFactory.isUnsafeAvailable()) {
            try {
                return UnsafeInjectable.create(urlClassLoader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return injector.get();
    }

    private static boolean isJigsawActive() {
        try {
            Class.forName("java.lang.Module");
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        return false;
    }

    private static boolean isUnsafeAvailable() {
        try {
            Class.forName("sun.misc.Unsafe");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

