/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.helper;

import io.github.slimjar.downloader.DependencyDownloader;
import io.github.slimjar.downloader.DependencyDownloaderFactory;
import io.github.slimjar.downloader.output.DependencyOutputWriterFactory;
import io.github.slimjar.downloader.strategy.FilePathStrategy;
import io.github.slimjar.downloader.verify.DependencyVerifierFactory;
import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.injector.DependencyInjectorFactory;
import io.github.slimjar.injector.helper.InjectionHelper;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.relocation.Relocator;
import io.github.slimjar.relocation.RelocatorFactory;
import io.github.slimjar.relocation.helper.RelocationHelper;
import io.github.slimjar.relocation.helper.RelocationHelperFactory;
import io.github.slimjar.resolver.DependencyResolver;
import io.github.slimjar.resolver.DependencyResolverFactory;
import io.github.slimjar.resolver.ResolutionResult;
import io.github.slimjar.resolver.data.DependencyData;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import io.github.slimjar.resolver.mirrors.MirrorSelector;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;

public final class InjectionHelperFactory {
    @NotNull
    private final Path downloadDirectoryPath;
    @NotNull
    private final RelocatorFactory relocatorFactory;
    @NotNull
    private final RelocationHelperFactory relocationHelperFactory;
    @NotNull
    private final DependencyResolverFactory resolverFactory;
    @NotNull
    private final RepositoryEnquirerFactory enquirerFactory;
    @NotNull
    private final DependencyDownloaderFactory downloaderFactory;
    @NotNull
    private final DependencyVerifierFactory verifier;
    @NotNull
    private final MirrorSelector mirrorSelector;

    public InjectionHelperFactory(@NotNull Path downloadDirectoryPath, @NotNull RelocatorFactory relocatorFactory, @NotNull DependencyDataProviderFactory dataProviderFactory, @NotNull RelocationHelperFactory relocationHelperFactory, @NotNull DependencyInjectorFactory injectorFactory, @NotNull DependencyResolverFactory resolverFactory, @NotNull RepositoryEnquirerFactory enquirerFactory, @NotNull DependencyDownloaderFactory downloaderFactory, @NotNull DependencyVerifierFactory verifier, @NotNull MirrorSelector mirrorSelector) {
        this.downloadDirectoryPath = downloadDirectoryPath;
        this.relocatorFactory = relocatorFactory;
        this.relocationHelperFactory = relocationHelperFactory;
        this.resolverFactory = resolverFactory;
        this.enquirerFactory = enquirerFactory;
        this.downloaderFactory = downloaderFactory;
        this.verifier = verifier;
        this.mirrorSelector = mirrorSelector;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public InjectionHelper create(@NotNull DependencyData data, @NotNull Map<String, ResolutionResult> preResolvedResults) throws InjectorException {
        Collection<Repository> repositories = this.mirrorSelector.select(data.repositories(), data.mirrors());
        Relocator relocator = this.relocatorFactory.create(data.relocations());
        RelocationHelper relocationHelper = this.relocationHelperFactory.create(relocator);
        FilePathStrategy filePathStrategy = FilePathStrategy.createDefault(this.downloadDirectoryPath.toFile());
        DependencyOutputWriterFactory outputWriterFactory = new DependencyOutputWriterFactory(filePathStrategy);
        DependencyResolver resolver = this.resolverFactory.create(repositories, preResolvedResults, this.enquirerFactory);
        DependencyDownloader downloader = this.downloaderFactory.create(outputWriterFactory, resolver, this.verifier.create(resolver));
        return new InjectionHelper(downloader, relocationHelper);
    }
}

