/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.helper;

import io.github.slimjar.downloader.DependencyDownloader;
import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.relocation.helper.RelocationHelper;
import io.github.slimjar.resolver.data.Dependency;
import java.io.File;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public final class InjectionHelper {
    private final Set<Dependency> injectedDependencies;
    private final DependencyDownloader dependencyDownloader;
    private final RelocationHelper relocationHelper;

    public InjectionHelper(DependencyDownloader dependencyDownloader, RelocationHelper relocationHelper, Set<Dependency> injectedDependencies) {
        this.dependencyDownloader = dependencyDownloader;
        this.relocationHelper = relocationHelper;
        this.injectedDependencies = injectedDependencies;
    }

    public InjectionHelper(DependencyDownloader dependencyDownloader, RelocationHelper relocationHelper) {
        this(dependencyDownloader, relocationHelper, new HashSet<Dependency>());
    }

    @NotNull
    public Optional<File> fetch(Dependency dependency) throws InjectorException {
        return this.dependencyDownloader.download(dependency).map(download -> {
            this.injectedDependencies.add(dependency);
            return this.relocationHelper.relocate(dependency, (File)download);
        });
    }

    public boolean isInjected(Dependency dependency) {
        return this.injectedDependencies.contains(dependency);
    }
}

