/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.agent;

import io.github.slimjar.app.builder.ApplicationBuilder;
import io.github.slimjar.app.module.ModuleExtractor;
import io.github.slimjar.app.module.TemporaryModuleExtractor;
import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.injector.agent.InstrumentationFactory;
import io.github.slimjar.injector.loader.InstrumentationInjectable;
import io.github.slimjar.injector.loader.IsolatedInjectableClassLoader;
import io.github.slimjar.injector.loader.manifest.JarManifestGenerator;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.relocation.JarFileRelocator;
import io.github.slimjar.relocation.PassthroughRelocator;
import io.github.slimjar.relocation.RelocationRule;
import io.github.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import io.github.slimjar.resolver.data.Dependency;
import io.github.slimjar.resolver.data.DependencyData;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.util.Packages;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;

public final class ByteBuddyInstrumentationFactory
implements InstrumentationFactory {
    @NotNull
    public static final String AGENT_JAR = "loader-agent.isolated-jar";
    @NotNull
    private static final String AGENT_PACKAGE = "io#github#slimjar#injector#agent";
    @NotNull
    private static final String AGENT_CLASS = "ClassLoaderAgent";
    @NotNull
    private static final String BYTE_BUDDY_AGENT_CLASS = "net#bytebuddy#agent#ByteBuddyAgent";
    @NotNull
    private final URL agentJarUrl;
    @NotNull
    private final ModuleExtractor extractor;
    @NotNull
    private final JarRelocatorFacadeFactory relocatorFacadeFactory;

    public ByteBuddyInstrumentationFactory(@NotNull JarRelocatorFacadeFactory relocatorFacadeFactory) throws NullPointerException {
        this(Objects.requireNonNull(InstrumentationInjectable.class.getClassLoader().getResource(AGENT_JAR)), new TemporaryModuleExtractor(), relocatorFacadeFactory);
    }

    @Contract(pure=true)
    public ByteBuddyInstrumentationFactory(@NotNull URL agentJarUrl, @NotNull ModuleExtractor extractor, @NotNull JarRelocatorFacadeFactory relocatorFacadeFactory) {
        this.agentJarUrl = agentJarUrl;
        this.extractor = extractor;
        this.relocatorFacadeFactory = relocatorFacadeFactory;
    }

    @Override
    @NotNull
    public Instrumentation create() throws InjectorException {
        File relocatedFile;
        File inputFile;
        URL extractedURL = this.extractor.extractModule(this.agentJarUrl, "loader-agent");
        String pattern = ByteBuddyInstrumentationFactory.generatePattern();
        String relocatedAgentClass = String.format("%s.%s", pattern, AGENT_CLASS);
        RelocationRule relocationRule = new RelocationRule(Packages.fix(AGENT_PACKAGE), pattern, Collections.emptySet(), Collections.emptySet());
        JarFileRelocator relocator = new JarFileRelocator(Collections.singleton(relocationRule), this.relocatorFacadeFactory);
        try {
            inputFile = new File(extractedURL.toURI());
            relocatedFile = File.createTempFile("slimjar-agent", ".jar");
        }
        catch (IOException | URISyntaxException err) {
            throw new InjectorException("Failed to create temporary file for relocated agent", err);
        }
        IsolatedInjectableClassLoader classLoader = new IsolatedInjectableClassLoader();
        relocator.relocate(inputFile, relocatedFile);
        JarManifestGenerator.with(relocatedFile.toURI()).attribute("Manifest-Version", "1.0").attribute("Agent-Class", relocatedAgentClass).generate();
        ApplicationBuilder.injecting("SlimJar-Agent", classLoader).dataProviderFactory(dataUrl -> ByteBuddyInstrumentationFactory::getDependency).relocatorFactory(rules -> new PassthroughRelocator()).relocationHelperFactory(rel -> (dependency, file) -> file).build();
        try {
            Class<?> byteBuddyAgentClass = Class.forName(Packages.fix(BYTE_BUDDY_AGENT_CLASS), true, classLoader);
            Method attachMethod = byteBuddyAgentClass.getMethod("attach", File.class, String.class, String.class);
            Class<?> processHandle = Class.forName("java.lang.ProcessHandle");
            Method currentMethod = processHandle.getMethod("current", new Class[0]);
            Method pidMethod = processHandle.getMethod("pid", new Class[0]);
            Object currentProcess = currentMethod.invoke(processHandle, new Object[0]);
            Long processId = (Long)pidMethod.invoke(currentProcess, new Object[0]);
            attachMethod.invoke(null, relocatedFile, String.valueOf(processId), "");
            Class<?> agentClass = Class.forName(relocatedAgentClass, true, ClassLoader.getSystemClassLoader());
            Method instrMethod = agentClass.getMethod("getInstrumentation", new Class[0]);
            return (Instrumentation)instrMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException err) {
            throw new InjectorException("Encountered exception while creating ByteBuddy instructions.", err);
        }
    }

    @NotNull
    private static DependencyData getDependency() {
        Dependency byteBuddy = new Dependency("net.bytebuddy", "byte-buddy-agent", "1.11.0", null, Collections.emptyList());
        return new DependencyData(Collections.emptySet(), Collections.singleton(Repository.central()), Collections.singleton(byteBuddy), Collections.emptyList());
    }

    @Contract(pure=true)
    @NotNull
    private static String generatePattern() {
        return "slimjar.%s".formatted(UUID.randomUUID());
    }
}

