/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector;

import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.injector.DependencyInjector;
import io.github.slimjar.injector.helper.InjectionHelper;
import io.github.slimjar.injector.helper.InjectionHelperFactory;
import io.github.slimjar.injector.loader.Injectable;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.ResolutionResult;
import io.github.slimjar.resolver.data.Dependency;
import io.github.slimjar.resolver.data.DependencyData;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class SimpleDependencyInjector
implements DependencyInjector {
    private final InjectionHelperFactory injectionHelperFactory;
    private final List<Dependency> processingDependencies = Collections.synchronizedList(new ArrayList());

    public SimpleDependencyInjector(InjectionHelperFactory injectionHelperFactory) {
        this.injectionHelperFactory = injectionHelperFactory;
    }

    @Override
    public void inject(@NotNull Injectable injectable, @NotNull DependencyData data, @NotNull Map<String, ResolutionResult> preResolvedResults) {
        InjectionHelper helper = this.injectionHelperFactory.create(data, preResolvedResults);
        this.injectDependencies(injectable, helper, data.dependencies());
    }

    private void injectDependencies(@NotNull Injectable injectable, @NotNull InjectionHelper injectionHelper, @NotNull Collection<Dependency> dependencies) throws InjectorException {
        dependencies.parallelStream().filter(dependency -> !injectionHelper.isInjected((Dependency)dependency)).forEach(dependency -> {
            if (this.processingDependencies.contains(dependency)) {
                return;
            }
            this.processingDependencies.add((Dependency)dependency);
            injectionHelper.fetch((Dependency)dependency).ifPresent(jarFile -> {
                try {
                    injectable.inject(jarFile.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.injectDependencies(injectable, injectionHelper, dependency.transitive());
            });
            this.processingDependencies.remove(dependency);
        });
    }
}

