/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.downloader.verify;

import io.github.slimjar.downloader.verify.ChecksumCalculator;
import io.github.slimjar.exceptions.VerificationException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.logging.LocationAwareProcessLogger;
import io.github.slimjar.logging.ProcessLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class FileChecksumCalculator
implements ChecksumCalculator {
    @NotNull
    private static final ProcessLogger LOGGER = LocationAwareProcessLogger.generic();
    @NotNull
    private static final String DIRECTORY_HASH = "DIRECTORY";
    @NotNull
    private final ThreadLocal<MessageDigest> digestThreadLocal;

    @Contract(pure=true)
    public FileChecksumCalculator(@NotNull String algorithm) throws VerificationException {
        MessageDigest templateDigest;
        try {
            templateDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new VerificationException("Failed to initialize checksum calculator", e);
        }
        this.digestThreadLocal = ThreadLocal.withInitial(() -> {
            try {
                return (MessageDigest)templateDigest.clone();
            }
            catch (CloneNotSupportedException err) {
                throw new VerificationException("Failed to clone digest template for thread local use.", err);
            }
        });
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String calculate(@NotNull File file) throws VerificationException {
        LOGGER.debug("Calculating hash for %s", file.getPath());
        if (file.isDirectory()) {
            return DIRECTORY_HASH;
        }
        MessageDigest digest = this.digestThreadLocal.get();
        try (FileInputStream stream = new FileInputStream(file);){
            int bytesCount;
            byte[] byteArray = new byte[1024];
            while ((bytesCount = stream.read(byteArray)) != -1) {
                digest.update(byteArray, 0, bytesCount);
            }
        }
        catch (IOException err) {
            throw new VerificationException("Encountered error while reading checksum file %s.".formatted(file.getPath()), err);
        }
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        sb.trimToSize();
        String result = sb.toString();
        LOGGER.debug("Hash for %s -> %s", file.getPath(), result);
        this.digestThreadLocal.remove();
        return result;
    }
}

