/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.downloader.verify;

import io.github.slimjar.downloader.output.OutputWriterFactory;
import io.github.slimjar.downloader.verify.ChecksumCalculator;
import io.github.slimjar.downloader.verify.ChecksumDependencyVerifier;
import io.github.slimjar.downloader.verify.DependencyVerifier;
import io.github.slimjar.downloader.verify.DependencyVerifierFactory;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.logging.LocationAwareProcessLogger;
import io.github.slimjar.logging.ProcessLogger;
import io.github.slimjar.resolver.DependencyResolver;

public final class ChecksumDependencyVerifierFactory
implements DependencyVerifierFactory {
    @NotNull
    private static final ProcessLogger LOGGER = LocationAwareProcessLogger.generic();
    @NotNull
    private final OutputWriterFactory outputWriterFactory;
    @NotNull
    private final DependencyVerifierFactory fallbackVerifierFactory;
    @NotNull
    private final ChecksumCalculator checksumCalculator;

    @Contract(pure=true)
    public ChecksumDependencyVerifierFactory(@NotNull OutputWriterFactory outputWriterFactory, @NotNull DependencyVerifierFactory fallbackVerifierFactory, @NotNull ChecksumCalculator checksumCalculator) {
        this.outputWriterFactory = outputWriterFactory;
        this.fallbackVerifierFactory = fallbackVerifierFactory;
        this.checksumCalculator = checksumCalculator;
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public DependencyVerifier create(@NotNull DependencyResolver resolver) {
        LOGGER.debug("Creating verifier...", new Object[0]);
        return new ChecksumDependencyVerifier(resolver, this.outputWriterFactory, this.fallbackVerifierFactory.create(resolver), this.checksumCalculator);
    }
}

