/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.downloader.strategy;

import io.github.slimjar.downloader.strategy.FilePathStrategy;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.logging.LocationAwareProcessLogger;
import io.github.slimjar.logging.ProcessLogger;
import io.github.slimjar.resolver.data.Dependency;
import java.io.File;
import java.util.Optional;

public final class RelocationFilePathStrategy
implements FilePathStrategy {
    @NotNull
    private static final ProcessLogger LOGGER = LocationAwareProcessLogger.generic();
    @NotNull
    private static final String DEPENDENCY_FILE_FORMAT = "%s/%s/%s/%s/relocated/%5$s/%3$s-%4$s.jar";
    @NotNull
    private final File rootDirectory;
    @NotNull
    private final String applicationName;

    @Contract(pure=true)
    private RelocationFilePathStrategy(@NotNull File rootDirectory, @NotNull String applicationName) {
        this.rootDirectory = rootDirectory;
        this.applicationName = applicationName;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public File selectFileFor(@NotNull Dependency dependency) {
        String extendedVersion = Optional.ofNullable(dependency.snapshotId()).map(s -> "-" + s).orElse("");
        String path = String.format(DEPENDENCY_FILE_FORMAT, this.rootDirectory.getPath(), dependency.groupId().replace('.', '/'), dependency.artifactId(), dependency.version() + extendedVersion, this.applicationName);
        LOGGER.debug("Selected file for relocated %s at %s. ", dependency.artifactId(), path);
        return new File(path);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static FilePathStrategy createStrategy(@NotNull File rootDirectory, @NotNull String applicationName) throws IllegalStateException {
        FilePathStrategy.validateDirectory(rootDirectory);
        return new RelocationFilePathStrategy(rootDirectory, applicationName);
    }
}

