/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.downloader.strategy;

import io.github.slimjar.downloader.strategy.FolderedFilePathStrategy;
import io.github.slimjar.downloader.strategy.RelocationFilePathStrategy;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.data.Dependency;
import java.io.File;

@FunctionalInterface
public interface FilePathStrategy {
    @NotNull
    public File selectFileFor(@NotNull Dependency var1);

    @NotNull
    public static FilePathStrategy createDefault(@NotNull File root) {
        return FolderedFilePathStrategy.createStrategy(root);
    }

    @Contract(pure=true)
    @NotNull
    public static FilePathStrategy createRelocationStrategy(@NotNull File root, @NotNull String applicationName) {
        return RelocationFilePathStrategy.createStrategy(root, applicationName);
    }

    @Contract(pure=true)
    public static void validateDirectory(@NotNull File rootDirectory) throws IllegalStateException {
        if (!rootDirectory.exists() && !rootDirectory.mkdirs()) {
            throw new IllegalStateException("Failed to create root directory for checksum file strategy (%s).".formatted(rootDirectory));
        }
        if (!rootDirectory.isDirectory()) {
            throw new IllegalStateException("Root directory for checksum file strategy is not a directory (%s).".formatted(rootDirectory));
        }
    }
}

