/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.app.builder;

import io.github.slimjar.app.module.ModuleExtractor;
import io.github.slimjar.app.module.TemporaryModuleExtractor;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.util.Modules;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record IsolationConfiguration(@NotNull String applicationClass, @NotNull Collection<String> modules, @NotNull ClassLoader parentClassloader, @NotNull ModuleExtractor moduleExtractor) {
    @Contract(pure=true)
    public IsolationConfiguration(@NotNull String applicationClass, @NotNull Collection<String> modules, @NotNull ClassLoader parentClassloader, @NotNull ModuleExtractor moduleExtractor) {
        this.applicationClass = applicationClass;
        this.modules = Collections.unmodifiableCollection(modules);
        this.parentClassloader = parentClassloader;
        this.moduleExtractor = moduleExtractor;
    }

    @Contract(pure=true)
    @NotNull
    public static Builder builder(@NotNull String applicationClass) {
        return new Builder().applicationClass(applicationClass);
    }

    public static final class Builder {
        private String applicationClass;
        @NotNull
        private Set<String> modules = Collections.emptySet();
        private ClassLoader parentClassloader;
        private ModuleExtractor moduleExtractor;

        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder applicationClass(String applicationClass) {
            this.applicationClass = applicationClass;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder modules(String ... modules) {
            this.modules = Stream.concat(this.modules.stream(), Arrays.stream(modules)).collect(Collectors.toUnmodifiableSet());
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder parentClassLoader(@NotNull ClassLoader classLoader) {
            this.parentClassloader = classLoader;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder moduleExtractor(@NotNull ModuleExtractor moduleExtractor) {
            this.moduleExtractor = moduleExtractor;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        String getApplicationClass() {
            if (this.applicationClass == null) {
                throw new AssertionError((Object)"Application Class not Provided!");
            }
            return this.applicationClass;
        }

        @Contract(mutates="this")
        @NotNull
        Collection<String> getModules() {
            if (this.modules.isEmpty()) {
                this.modules = Modules.findLocalModules();
            }
            return this.modules;
        }

        @Contract(mutates="this")
        @NotNull
        ClassLoader getParentClassloader() {
            if (this.parentClassloader == null) {
                this.parentClassloader = ClassLoader.getSystemClassLoader().getParent();
            }
            return this.parentClassloader;
        }

        @Contract(mutates="this")
        @NotNull
        ModuleExtractor getModuleExtractor() {
            if (this.moduleExtractor == null) {
                this.moduleExtractor = new TemporaryModuleExtractor();
            }
            return this.moduleExtractor;
        }

        @Contract(value=" -> new", mutates="this")
        @NotNull
        public IsolationConfiguration build() {
            return new IsolationConfiguration(this.getApplicationClass(), this.getModules(), this.getParentClassloader(), this.getModuleExtractor());
        }
    }
}

