/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.app.builder;

import io.github.slimjar.app.Application;
import io.github.slimjar.app.builder.ApplicationBuilder;
import io.github.slimjar.app.builder.IsolationConfiguration;
import io.github.slimjar.exceptions.SlimJarException;
import io.github.slimjar.injector.DependencyInjector;
import io.github.slimjar.injector.loader.IsolatedInjectableClassLoader;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.resolver.ResolutionResult;
import io.github.slimjar.resolver.data.DependencyData;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProvider;
import io.github.slimjar.resolver.reader.resolution.PreResolutionDataProvider;
import io.github.slimjar.util.Modules;
import io.github.slimjar.util.Reflections;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;

public final class IsolatedApplicationBuilder
extends ApplicationBuilder {
    @NotNull
    private final IsolationConfiguration isolationConfiguration;
    private final @Nullable Object @NotNull [] arguments;

    @Contract(pure=true)
    public IsolatedApplicationBuilder(@NotNull String applicationName, @NotNull IsolationConfiguration isolationConfiguration, Object ... arguments) {
        super(applicationName);
        this.isolationConfiguration = isolationConfiguration;
        this.arguments = (Object[])arguments.clone();
    }

    @Override
    @Contract(value="-> new", mutates="this")
    @NotNull
    public Application buildApplication() throws SlimJarException {
        DependencyInjector injector = this.createInjector();
        URL[] moduleUrls = Modules.extract(this.isolationConfiguration.moduleExtractor(), this.isolationConfiguration.modules());
        IsolatedInjectableClassLoader classLoader = new IsolatedInjectableClassLoader(moduleUrls, Collections.singleton(Application.class), this.isolationConfiguration.parentClassloader());
        DependencyDataProvider dataProvider = this.getDataProviderFactory().create(this.getDependencyFileUrl());
        DependencyData selfDependencyData = dataProvider.get();
        PreResolutionDataProvider preResolutionDataProvider = this.getPreResolutionDataProviderFactory().create(this.getPreResolutionFileUrl());
        Map<String, ResolutionResult> preResolutionResultMap = preResolutionDataProvider.get();
        injector.inject(classLoader, selfDependencyData, preResolutionResultMap);
        for (URL module : moduleUrls) {
            DependencyDataProvider moduleDataProvider = this.getModuleDataProviderFactory().create(module);
            PreResolutionDataProvider modulePreResolutionDataProvider = this.getModulePreResolutionDataProviderFactory().create(module);
            injector.inject(classLoader, moduleDataProvider.get(), modulePreResolutionDataProvider.get());
        }
        try {
            Class<?> applicationClass = Class.forName(this.isolationConfiguration.applicationClass(), true, classLoader);
            return (Application)Reflections.findConstructor(applicationClass, this.arguments).newInstance(this.arguments);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException err) {
            throw new SlimJarException("Failed to reflectively create application class.", err);
        }
    }
}

