/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.app.builder;

import io.github.slimjar.app.Application;
import io.github.slimjar.app.builder.InjectingApplicationBuilder;
import io.github.slimjar.app.builder.IsolatedApplicationBuilder;
import io.github.slimjar.app.builder.IsolationConfiguration;
import io.github.slimjar.downloader.DependencyDownloaderFactory;
import io.github.slimjar.downloader.URLDependencyDownloaderFactory;
import io.github.slimjar.downloader.output.DependencyOutputWriterFactory;
import io.github.slimjar.downloader.strategy.ChecksumFilePathStrategy;
import io.github.slimjar.downloader.strategy.FilePathStrategy;
import io.github.slimjar.downloader.verify.ChecksumDependencyVerifierFactory;
import io.github.slimjar.downloader.verify.DependencyVerifierFactory;
import io.github.slimjar.downloader.verify.FileChecksumCalculator;
import io.github.slimjar.downloader.verify.PassthroughDependencyVerifierFactory;
import io.github.slimjar.injector.DependencyInjector;
import io.github.slimjar.injector.DependencyInjectorFactory;
import io.github.slimjar.injector.SimpleDependencyInjectorFactory;
import io.github.slimjar.injector.helper.InjectionHelperFactory;
import io.github.slimjar.injector.loader.Injectable;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.logging.LogDispatcher;
import io.github.slimjar.logging.MediatingProcessLogger;
import io.github.slimjar.logging.ProcessLogger;
import io.github.slimjar.relocation.JarFileRelocatorFactory;
import io.github.slimjar.relocation.RelocatorFactory;
import io.github.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import io.github.slimjar.relocation.facade.ReflectiveJarRelocatorFacadeFactory;
import io.github.slimjar.relocation.helper.RelocationHelperFactory;
import io.github.slimjar.relocation.helper.VerifyingRelocationHelperFactory;
import io.github.slimjar.relocation.meta.FlatFileMetaMediatorFactory;
import io.github.slimjar.relocation.meta.MetaMediatorFactory;
import io.github.slimjar.resolver.CachingDependencyResolverFactory;
import io.github.slimjar.resolver.DependencyResolverFactory;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.enquirer.PingingRepositoryEnquirerFactory;
import io.github.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import io.github.slimjar.resolver.mirrors.MirrorSelector;
import io.github.slimjar.resolver.mirrors.SimpleMirrorSelector;
import io.github.slimjar.resolver.pinger.HttpURLPinger;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;
import io.github.slimjar.resolver.reader.dependency.ExternalDependencyDataProviderFactory;
import io.github.slimjar.resolver.reader.dependency.GsonDependencyDataProviderFactory;
import io.github.slimjar.resolver.reader.facade.GsonFacadeFactory;
import io.github.slimjar.resolver.reader.facade.ReflectiveGsonFacadeFactory;
import io.github.slimjar.resolver.reader.resolution.GsonPreResolutionDataProviderFactory;
import io.github.slimjar.resolver.reader.resolution.PreResolutionDataProviderFactory;
import io.github.slimjar.resolver.strategy.MavenChecksumPathResolutionStrategy;
import io.github.slimjar.resolver.strategy.MavenPathResolutionStrategy;
import io.github.slimjar.resolver.strategy.MavenPomPathResolutionStrategy;
import io.github.slimjar.resolver.strategy.MavenSnapshotPathResolutionStrategy;
import io.github.slimjar.resolver.strategy.MediatingPathResolutionStrategy;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;

public abstract class ApplicationBuilder {
    @NotNull
    private static final Path DEFAULT_DOWNLOAD_DIRECTORY = Path.of(System.getProperty("user.home"), ".slimjar");
    @NotNull
    private final String applicationName;
    @Nullable
    private URL dependencyFileUrl;
    @Nullable
    private URL preResolutionFileUrl;
    @Nullable
    private Path downloadDirectoryPath;
    @Nullable
    private RelocatorFactory relocatorFactory;
    @Nullable
    private DependencyDataProviderFactory moduleDataProviderFactory;
    @Nullable
    private PreResolutionDataProviderFactory modulePreResolutionDataProviderFactory;
    @Nullable
    private DependencyDataProviderFactory dataProviderFactory;
    @Nullable
    private PreResolutionDataProviderFactory preResolutionDataProviderFactory;
    @Nullable
    private RelocationHelperFactory relocationHelperFactory;
    @Nullable
    private DependencyInjectorFactory injectorFactory;
    @Nullable
    private DependencyResolverFactory resolverFactory;
    @Nullable
    private RepositoryEnquirerFactory enquirerFactory;
    @Nullable
    private DependencyDownloaderFactory downloaderFactory;
    @Nullable
    private DependencyVerifierFactory verifierFactory;
    @Nullable
    private MirrorSelector mirrorSelector;
    @Nullable
    private ProcessLogger logger;

    @Contract(pure=true)
    protected ApplicationBuilder(@NotNull String applicationName) {
        this.applicationName = applicationName;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ApplicationBuilder isolated(@NotNull String name, @NotNull IsolationConfiguration config, Object ... args) {
        return new IsolatedApplicationBuilder(name, config, args);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ApplicationBuilder appending(@NotNull String name) {
        return InjectingApplicationBuilder.createAppending(name);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static ApplicationBuilder injecting(@NotNull String name, @NotNull Injectable injectable) {
        return new InjectingApplicationBuilder(name, injectable);
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder dependencyFileUrl(@NotNull URL dependencyFileUrl) {
        this.dependencyFileUrl = dependencyFileUrl;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder preResolutionFileUrl(@NotNull URL preResolutionFileUrl) {
        this.preResolutionFileUrl = preResolutionFileUrl;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder downloadDirectoryPath(@NotNull Path downloadDirectoryPath) {
        this.downloadDirectoryPath = downloadDirectoryPath;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder relocatorFactory(@NotNull RelocatorFactory relocatorFactory) {
        this.relocatorFactory = relocatorFactory;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder moduleDataProviderFactory(@NotNull DependencyDataProviderFactory moduleDataProviderFactory) {
        this.moduleDataProviderFactory = moduleDataProviderFactory;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder modulePreResolutionDataProviderFactory(@NotNull PreResolutionDataProviderFactory modulePreResolutionDataProviderFactory) {
        this.modulePreResolutionDataProviderFactory = modulePreResolutionDataProviderFactory;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder dataProviderFactory(@NotNull DependencyDataProviderFactory dataProviderFactory) {
        this.dataProviderFactory = dataProviderFactory;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder preResolutionDataProviderFactory(@NotNull PreResolutionDataProviderFactory preResolutionDataProviderFactory) {
        this.preResolutionDataProviderFactory = preResolutionDataProviderFactory;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder relocationHelperFactory(@NotNull RelocationHelperFactory relocationHelperFactory) {
        this.relocationHelperFactory = relocationHelperFactory;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder injectorFactory(@NotNull DependencyInjectorFactory injectorFactory) {
        this.injectorFactory = injectorFactory;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder resolverFactory(@NotNull DependencyResolverFactory resolverFactory) {
        this.resolverFactory = resolverFactory;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder enquirerFactory(@NotNull RepositoryEnquirerFactory enquirerFactory) {
        this.enquirerFactory = enquirerFactory;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder downloaderFactory(@NotNull DependencyDownloaderFactory downloaderFactory) {
        this.downloaderFactory = downloaderFactory;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder verifierFactory(@NotNull DependencyVerifierFactory verifierFactory) {
        this.verifierFactory = verifierFactory;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder mirrorSelector(@NotNull MirrorSelector mirrorSelector) {
        this.mirrorSelector = mirrorSelector;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final ApplicationBuilder logger(@NotNull ProcessLogger logger) {
        this.logger = logger;
        return this;
    }

    @Contract(pure=true)
    @NotNull
    protected final String getApplicationName() {
        return this.applicationName;
    }

    @Contract(mutates="this")
    @NotNull
    protected final URL getDependencyFileUrl() {
        if (this.dependencyFileUrl == null) {
            this.dependencyFileUrl = this.getClass().getClassLoader().getResource("slimjar.json");
        }
        return Objects.requireNonNull(this.dependencyFileUrl);
    }

    @Contract(mutates="this")
    @NotNull
    protected final URL getPreResolutionFileUrl() {
        if (this.preResolutionFileUrl == null) {
            this.preResolutionFileUrl = this.getClass().getClassLoader().getResource("slimjar-resolutions.json");
        }
        return Objects.requireNonNull(this.preResolutionFileUrl);
    }

    @Contract(mutates="this")
    @NotNull
    protected final Path getDownloadDirectoryPath() {
        if (this.downloadDirectoryPath == null) {
            this.downloadDirectoryPath = DEFAULT_DOWNLOAD_DIRECTORY;
        }
        return this.downloadDirectoryPath;
    }

    @Contract(mutates="this")
    @NotNull
    protected final RelocatorFactory getRelocatorFactory() {
        if (this.relocatorFactory == null) {
            JarRelocatorFacadeFactory jarRelocatorFacadeFactory = ReflectiveJarRelocatorFacadeFactory.create(this.getDownloadDirectoryPath(), Collections.singleton(Repository.central()));
            this.relocatorFactory = new JarFileRelocatorFactory(jarRelocatorFacadeFactory);
        }
        return this.relocatorFactory;
    }

    @Contract(mutates="this")
    @NotNull
    protected final DependencyDataProviderFactory getModuleDataProviderFactory() {
        if (this.moduleDataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), Collections.singleton(Repository.central()));
            this.moduleDataProviderFactory = new ExternalDependencyDataProviderFactory(gsonFacadeFactory);
        }
        return this.moduleDataProviderFactory;
    }

    @Contract(mutates="this")
    @NotNull
    protected final PreResolutionDataProviderFactory getModulePreResolutionDataProviderFactory() {
        if (this.modulePreResolutionDataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), Collections.singleton(Repository.central()));
            this.modulePreResolutionDataProviderFactory = new GsonPreResolutionDataProviderFactory(gsonFacadeFactory);
        }
        return this.modulePreResolutionDataProviderFactory;
    }

    @Contract(mutates="this")
    @NotNull
    protected final DependencyDataProviderFactory getDataProviderFactory() {
        if (this.dataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), Collections.singleton(Repository.central()));
            this.dataProviderFactory = new GsonDependencyDataProviderFactory(gsonFacadeFactory);
        }
        return this.dataProviderFactory;
    }

    @Contract(mutates="this")
    @NotNull
    protected final PreResolutionDataProviderFactory getPreResolutionDataProviderFactory() {
        if (this.preResolutionDataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), Collections.singleton(Repository.central()));
            this.preResolutionDataProviderFactory = new GsonPreResolutionDataProviderFactory(gsonFacadeFactory);
        }
        return this.preResolutionDataProviderFactory;
    }

    @Contract(mutates="this")
    @NotNull
    protected final RelocationHelperFactory getRelocationHelperFactory() {
        if (this.relocationHelperFactory == null) {
            FileChecksumCalculator checksumCalculator = new FileChecksumCalculator("SHA-256");
            FilePathStrategy pathStrategy = FilePathStrategy.createRelocationStrategy(this.getDownloadDirectoryPath().toFile(), this.getApplicationName());
            FlatFileMetaMediatorFactory mediatorFactory = new FlatFileMetaMediatorFactory();
            this.relocationHelperFactory = new VerifyingRelocationHelperFactory(checksumCalculator, pathStrategy, (MetaMediatorFactory)mediatorFactory);
        }
        return this.relocationHelperFactory;
    }

    @Contract(mutates="this")
    @NotNull
    protected final DependencyInjectorFactory getInjectorFactory() {
        if (this.injectorFactory == null) {
            this.injectorFactory = new SimpleDependencyInjectorFactory();
        }
        return this.injectorFactory;
    }

    @Contract(mutates="this")
    @NotNull
    protected final DependencyResolverFactory getResolverFactory() {
        if (this.resolverFactory == null) {
            HttpURLPinger pinger = new HttpURLPinger();
            this.resolverFactory = new CachingDependencyResolverFactory(pinger);
        }
        return this.resolverFactory;
    }

    @Contract(mutates="this")
    @NotNull
    protected final RepositoryEnquirerFactory getEnquirerFactory() {
        if (this.enquirerFactory == null) {
            MavenPathResolutionStrategy releaseStrategy = new MavenPathResolutionStrategy();
            MavenSnapshotPathResolutionStrategy snapshotStrategy = new MavenSnapshotPathResolutionStrategy();
            MediatingPathResolutionStrategy resolutionStrategy = new MediatingPathResolutionStrategy(releaseStrategy, snapshotStrategy);
            MavenPomPathResolutionStrategy pomURLCreationStrategy = new MavenPomPathResolutionStrategy();
            MavenChecksumPathResolutionStrategy checksumResolutionStrategy = new MavenChecksumPathResolutionStrategy("SHA-1", resolutionStrategy);
            HttpURLPinger urlPinger = new HttpURLPinger();
            this.enquirerFactory = new PingingRepositoryEnquirerFactory(resolutionStrategy, checksumResolutionStrategy, pomURLCreationStrategy, urlPinger);
        }
        return this.enquirerFactory;
    }

    @Contract(mutates="this")
    @NotNull
    protected final DependencyDownloaderFactory getDownloaderFactory() {
        if (this.downloaderFactory == null) {
            this.downloaderFactory = new URLDependencyDownloaderFactory();
        }
        return this.downloaderFactory;
    }

    @Contract(mutates="this")
    @NotNull
    protected final DependencyVerifierFactory getVerifierFactory() {
        if (this.verifierFactory == null) {
            FilePathStrategy filePathStrategy = ChecksumFilePathStrategy.createStrategy(this.getDownloadDirectoryPath().toFile(), "SHA-1");
            DependencyOutputWriterFactory checksumOutputFactory = new DependencyOutputWriterFactory(filePathStrategy);
            PassthroughDependencyVerifierFactory fallback = new PassthroughDependencyVerifierFactory();
            FileChecksumCalculator checksumCalculator = new FileChecksumCalculator("SHA-1");
            this.verifierFactory = new ChecksumDependencyVerifierFactory(checksumOutputFactory, fallback, checksumCalculator);
        }
        return this.verifierFactory;
    }

    @Contract(mutates="this")
    @NotNull
    protected final MirrorSelector getMirrorSelector() {
        if (this.mirrorSelector == null) {
            this.mirrorSelector = new SimpleMirrorSelector();
        }
        return this.mirrorSelector;
    }

    @Contract(mutates="this")
    @NotNull
    protected final ProcessLogger getLogger() {
        if (this.logger == null) {
            this.logger = (msg, args) -> {};
        }
        return this.logger;
    }

    @Contract(value="-> new", mutates="this")
    @NotNull
    protected final DependencyInjector createInjector() {
        InjectionHelperFactory injectionHelperFactory = new InjectionHelperFactory(this.getDownloadDirectoryPath(), this.getRelocatorFactory(), this.getDataProviderFactory(), this.getRelocationHelperFactory(), this.getInjectorFactory(), this.getResolverFactory(), this.getEnquirerFactory(), this.getDownloaderFactory(), this.getVerifierFactory(), this.getMirrorSelector());
        return this.getInjectorFactory().create(injectionHelperFactory);
    }

    @Contract(value="-> new", mutates="this")
    @NotNull
    public final Application build() {
        MediatingProcessLogger mediatingLogger = LogDispatcher.getMediatingLogger();
        ProcessLogger logger = this.getLogger();
        mediatingLogger.addLogger(logger);
        Application result = this.buildApplication();
        mediatingLogger.removeLogger(logger);
        return result;
    }

    @Contract(value="-> new", mutates="this")
    @NotNull
    protected abstract Application buildApplication();
}

