//
// MIT License
//
// Copyright (c) 2021 Vaishnav Anil
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

package io.github.slimjar.relocation

import org.gradle.api.internal.catalog.ExternalModuleDependencyFactory

/**
 * Added as a wrapper for the [RelocationRule] due to Gradle not liking it
 */
class RelocationConfig {

    internal val inclusions = mutableListOf<String>()
    internal val exclusions = mutableListOf<String>()

    fun include(vararg pattern: String): RelocationConfig {
        // Shadow does some normalization, might be worth looking into
        inclusions.addAll(pattern)
        return this
    }

    fun exclude(vararg pattern: String): RelocationConfig {
        // Shadow does some normalization, might be worth looking into
        exclusions.addAll(pattern)
        return this
    }

    fun include(vararg patterns: ExternalModuleDependencyFactory.DependencyNotationSupplier): RelocationConfig {
        inclusions.addAll(patterns.map { it.asProvider().get().module.toString() }.toTypedArray())
        return this
    }

    fun exclude(vararg patterns: ExternalModuleDependencyFactory.DependencyNotationSupplier): RelocationConfig {
        exclusions.addAll(patterns.map { it.asProvider().get().module.toString() }.toTypedArray())
        return this
    }
}
