/*
 * Decompiled with CFR 0.152.
 */
package de.confinitum.pdfview.skin;

import de.confinitum.pdfview.PDFView;
import de.confinitum.pdfview.base.Document;
import de.confinitum.pdfview.base.PageKey;
import de.confinitum.pdfview.base.ToolbarConfig;
import de.confinitum.pdfview.base.UtilsKt;
import de.confinitum.pdfview.skin.MainScrollPane;
import de.confinitum.pdfview.skin.PostScroll;
import de.confinitum.pdfview.skin.ThumbnailListCell;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign2.MaterialDesignA;
import org.kordamp.ikonli.materialdesign2.MaterialDesignC;
import org.kordamp.ikonli.materialdesign2.MaterialDesignR;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ!\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020#H\u0002J\u001a\u0010$\u001a\u00020\u00182\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lde/confinitum/pdfview/skin/PDFViewSkin;", "Ljavafx/scene/control/SkinBase;", "Lde/confinitum/pdfview/PDFView;", "view", "<init>", "(Lde/confinitum/pdfview/PDFView;)V", "mainArea", "Lde/confinitum/pdfview/skin/MainScrollPane;", "requestedVValue", "Lde/confinitum/pdfview/skin/PostScroll;", "getRequestedVValue", "()Lde/confinitum/pdfview/skin/PostScroll;", "setRequestedVValue", "(Lde/confinitum/pdfview/skin/PostScroll;)V", "thumbnailWidth", "Ljavafx/beans/property/DoubleProperty;", "resetThumbnailWidth", "", "currentViewport", "Ljavafx/beans/property/ObjectProperty;", "Ljavafx/geometry/Rectangle2D;", "getCurrentViewport", "()Ljavafx/beans/property/ObjectProperty;", "setViewport", "", "rectangle", "registerThumbnailWidth", "w", "", "switchViewport", "oldPage", "", "newPage", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "createToolBar", "Ljavafx/scene/control/ToolBar;", "updateCurrentPageNumber", "pageField", "Ljavafx/scene/control/TextField;", "updateTotalPagesNumber", "totalPagesButton", "Ljavafx/scene/control/Button;", "kpdfx"})
@SourceDebugExtension(value={"SMAP\nPdfViewSkin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfViewSkin.kt\nde/confinitum/pdfview/skin/PDFViewSkin\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,337:1\n37#2:338\n36#2,3:339\n*S KotlinDebug\n*F\n+ 1 PdfViewSkin.kt\nde/confinitum/pdfview/skin/PDFViewSkin\n*L\n315#1:338\n315#1:339,3\n*E\n"})
public final class PDFViewSkin
extends SkinBase<PDFView> {
    @NotNull
    private final PDFView view;
    @NotNull
    private MainScrollPane mainArea;
    @NotNull
    private PostScroll requestedVValue;
    @NotNull
    private final DoubleProperty thumbnailWidth;
    private boolean resetThumbnailWidth;
    @NotNull
    private final ObjectProperty<Rectangle2D> currentViewport;

    public PDFViewSkin(@NotNull PDFView view) {
        BorderPane borderPane;
        ListView thumbnailListView;
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        super((Control)view);
        this.view = view;
        this.requestedVValue = PostScroll.NONE;
        this.thumbnailWidth = (DoubleProperty)new SimpleDoubleProperty(0.0);
        this.currentViewport = (ObjectProperty)new SimpleObjectProperty((Object)new Rectangle2D(0.0, 0.0, 1.0, 1.0));
        ListView $this$_init__u24lambda_u248 = thumbnailListView = new ListView();
        boolean bl = false;
        $this$_init__u24lambda_u248.getStyleClass().add((Object)"thumbnail-list-view");
        $this$_init__u24lambda_u248.setPlaceholder(null);
        $this$_init__u24lambda_u248.setCellFactory(arg_0 -> PDFViewSkin.lambda$8$lambda$0(this, arg_0));
        $this$_init__u24lambda_u248.prefWidthProperty().bind((ObservableValue)this.thumbnailWidth.add(40));
        $this$_init__u24lambda_u248.setMinWidth(Double.NEGATIVE_INFINITY);
        $this$_init__u24lambda_u248.getSelectionModel().selectedItemProperty().addListener((arg_0, arg_1, arg_2) -> PDFViewSkin.lambda$8$lambda$3((arg_0, arg_1, arg_2) -> PDFViewSkin.lambda$8$lambda$2(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        this.view.pageProperty().addListener(arg_0 -> PDFViewSkin.lambda$8$lambda$4($this$_init__u24lambda_u248, this, arg_0));
        $this$_init__u24lambda_u248.itemsProperty().addListener((arg_0, arg_1, arg_2) -> PDFViewSkin.lambda$8$lambda$7((arg_0, arg_1, arg_2) -> PDFViewSkin.lambda$8$lambda$6($this$_init__u24lambda_u248, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        $this$_init__u24lambda_u248.requestFocus();
        ToolBar toolBar = this.createToolBar();
        HBox it = toolBar;
        boolean bl2 = false;
        ObservableList observableList = it.getStylesheets();
        Object object = PDFView.class.getResource("/pdf-view.css");
        if (object == null || (object = ((URL)object).toExternalForm()) == null) {
            object = "";
        }
        observableList.add(object);
        it.visibleProperty().bind((ObservableValue)this.view.showToolBarProperty());
        it.managedProperty().bind((ObservableValue)this.view.showToolBarProperty());
        ToolBar toolBar2 = toolBar;
        MainScrollPane mainScrollPane = new MainScrollPane(this);
        it = mainScrollPane;
        PDFViewSkin pDFViewSkin = this;
        boolean bl3 = false;
        VBox.setVgrow((Node)((Node)it), (Priority)Priority.ALWAYS);
        pDFViewSkin.mainArea = mainScrollPane;
        it = new HBox[]{this.mainArea};
        HBox it2 = it = new VBox((Node[])it);
        boolean bl4 = false;
        it2.setFillWidth(true);
        HBox hBox = it;
        it2 = new HBox[]{thumbnailListView};
        HBox it3 = it2 = new HBox((Node[])it2);
        boolean bl5 = false;
        it3.setFillHeight(true);
        it3.visibleProperty().bind((ObservableValue)this.view.showThumbnailsProperty());
        it3.managedProperty().bind((ObservableValue)this.view.showThumbnailsProperty());
        HBox leftSide = it2;
        BorderPane it4 = borderPane = new BorderPane();
        boolean bl6 = false;
        it4.setTop((Node)toolBar2);
        it4.setLeft((Node)leftSide);
        it4.setCenter((Node)hBox);
        it4.setFocusTraversable(false);
        BorderPane borderPane2 = borderPane;
        this.getChildren().add((Object)borderPane2);
        this.view.documentProperty().addListener((arg_0, arg_1, arg_2) -> PDFViewSkin._init_$lambda$16((arg_0, arg_1, arg_2) -> PDFViewSkin._init_$lambda$15(this, thumbnailListView, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        if (thumbnailListView.getItems().isEmpty()) {
            Document document = this.view.getDocument();
            ObservableList<PageKey> it5 = document != null ? document.getPagesList() : null;
            boolean bl7 = false;
            thumbnailListView.setItems(it5);
        }
        this.view.pageProperty().addListener((arg_0, arg_1, arg_2) -> PDFViewSkin._init_$lambda$19((arg_0, arg_1, arg_2) -> PDFViewSkin._init_$lambda$18(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        this.currentViewport.addListener((arg_0, arg_1, arg_2) -> PDFViewSkin._init_$lambda$21((arg_0, arg_1, arg_2) -> PDFViewSkin._init_$lambda$20(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
    }

    @NotNull
    public final PostScroll getRequestedVValue() {
        return this.requestedVValue;
    }

    public final void setRequestedVValue(@NotNull PostScroll postScroll) {
        Intrinsics.checkNotNullParameter((Object)((Object)postScroll), (String)"<set-?>");
        this.requestedVValue = postScroll;
    }

    @NotNull
    public final ObjectProperty<Rectangle2D> getCurrentViewport() {
        return this.currentViewport;
    }

    public final void setViewport(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.mainArea.setViewport(rectangle);
    }

    public final void registerThumbnailWidth(double w) {
        if (this.resetThumbnailWidth) {
            double diff = this.thumbnailWidth.get() - w;
            if (diff > 4.0 || diff < 0.0) {
                this.thumbnailWidth.set(w + (double)2);
            }
            this.resetThumbnailWidth = false;
        } else {
            this.thumbnailWidth.set(Math.max(this.thumbnailWidth.get(), w));
        }
    }

    private final void switchViewport(Integer oldPage, Integer newPage) {
        block2: {
            int it;
            block3: {
                Integer n = oldPage;
                if (n != null) {
                    it = ((Number)n).intValue();
                    boolean bl = false;
                    Document document = this.view.getDocument();
                    if (document != null) {
                        document.setViewport(it, null);
                    }
                }
                Integer n2 = newPage;
                if (n2 == null) break block2;
                it = ((Number)n2).intValue();
                boolean bl = false;
                Rectangle2D vp = (Rectangle2D)this.currentViewport.get();
                Rectangle2D vpn = new Rectangle2D(Math.max(vp.getMinX(), 0.0), Math.max(vp.getMinY(), 0.0), Math.min(vp.getWidth(), 1.0), Math.min(vp.getHeight(), 1.0));
                if (Intrinsics.areEqual((Object)vpn, (Object)new Rectangle2D(0.0, 0.0, 1.0, 1.0))) break block3;
                Document document = this.view.getDocument();
                if (document == null) break block2;
                document.setViewport(it, vpn);
                break block2;
            }
            Document document = this.view.getDocument();
            if (document == null) break block2;
            document.setViewport(it, null);
        }
    }

    private final ToolBar createToolBar() {
        Object[] it;
        Button goRight;
        Node[] zoomLabel;
        Observable[] valueListener;
        Object[] objectArray;
        Object[] objectArray2;
        ToggleButton it2;
        ToggleButton toggleButton;
        PDFView view;
        PDFView pDFView = view = (PDFView)this.getSkinnable();
        Intrinsics.checkNotNull((Object)((Object)pDFView));
        ToolbarConfig config = pDFView.getToolbarConfig();
        List nodes = new ArrayList();
        if (config.getThumbnails()) {
            it2 = toggleButton = new ToggleButton();
            boolean bl = false;
            it2.setGraphic((Node)new FontIcon((Ikon)MaterialDesignA.ANIMATION_OUTLINE));
            objectArray2 = new String[]{"tool-bar-button", "show-thumbnails-button"};
            it2.getStyleClass().addAll(objectArray2);
            it2.setTooltip(new Tooltip("show/hide thumbnails"));
            it2.selectedProperty().bindBidirectional((Property)view.showThumbnailsProperty());
            ToggleButton showThumbnails = toggleButton;
            nodes.add(showThumbnails);
            nodes.add(new Separator(Orientation.VERTICAL));
        }
        if (config.getPageFit()) {
            it2 = toggleButton = new ToggleButton();
            boolean bl = false;
            it2.setGraphic((Node)new FontIcon((Ikon)MaterialDesignA.ARROW_EXPAND_VERTICAL));
            objectArray2 = new String[]{"tool-bar-button", "show-all-button"};
            it2.getStyleClass().addAll(objectArray2);
            it2.setTooltip(new Tooltip("Show all / whole page"));
            view.fitVerticalProperty().bindBidirectional((Property)it2.selectedProperty());
            ToggleButton showVertical = toggleButton;
            ToggleButton it3 = it2 = new ToggleButton();
            boolean bl2 = false;
            it3.setGraphic((Node)new FontIcon((Ikon)MaterialDesignA.ARROW_EXPAND_HORIZONTAL));
            objectArray = new String[]{"tool-bar-button", "show-all-button"};
            it3.getStyleClass().addAll(objectArray);
            it3.setTooltip(new Tooltip("fit horizontally"));
            view.fitHorizontalProperty().bindBidirectional((Property)it3.selectedProperty());
            ToggleButton showHorizontal = it2;
            nodes.add(showVertical);
            nodes.add(showHorizontal);
            nodes.add(new Separator(Orientation.VERTICAL));
        }
        if (config.getZooming()) {
            Slider zoomSlider;
            Slider $this$createToolBar_u24lambda_u2430 = zoomSlider = new Slider();
            boolean bl = false;
            $this$createToolBar_u24lambda_u2430.minProperty().set(0.0);
            $this$createToolBar_u24lambda_u2430.maxProperty().bind((ObservableValue)view.maxZoomFactorProperty());
            $this$createToolBar_u24lambda_u2430.setValue(view.getZoomFactor());
            $this$createToolBar_u24lambda_u2430.setShowTickMarks(true);
            $this$createToolBar_u24lambda_u2430.setMajorTickUnit(0.5);
            $this$createToolBar_u24lambda_u2430.setShowTickLabels(true);
            Ref.ObjectRef zoomListener = new Ref.ObjectRef();
            zoomListener.element = PDFViewSkin::createToolBar$lambda$30$lambda$27;
            valueListener = (arg_0, arg_1, arg_2) -> PDFViewSkin.createToolBar$lambda$30$lambda$28(view, zoomListener, arg_0, arg_1, arg_2);
            zoomListener.element = (arg_0, arg_1, arg_2) -> PDFViewSkin.createToolBar$lambda$30$lambda$29($this$createToolBar_u24lambda_u2430, (ChangeListener)valueListener, arg_0, arg_1, arg_2);
            $this$createToolBar_u24lambda_u2430.valueProperty().addListener((ChangeListener)valueListener);
            view.zoomFactorProperty().addListener((ChangeListener)zoomListener.element);
            zoomLabel = new Label("Zoom");
            nodes.add(zoomLabel);
            nodes.add(zoomSlider);
            nodes.add(new Separator(Orientation.VERTICAL));
        }
        if (config.getPages()) {
            Node[] it4 = zoomLabel = new Button();
            boolean bl = false;
            it4.setGraphic((Node)new FontIcon((Ikon)MaterialDesignC.CHEVRON_LEFT));
            it4.setTooltip(new Tooltip("Show previous page"));
            it4.setOnAction(arg_0 -> PDFViewSkin.createToolBar$lambda$33$lambda$31(view, arg_0));
            valueListener = new Observable[]{"tool-bar-button", "previous-page-button"};
            it4.getStyleClass().addAll((Object[])valueListener);
            valueListener = new Observable[]{view.pageProperty(), view.documentProperty()};
            it4.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> PDFViewSkin.createToolBar$lambda$33$lambda$32(view), (Observable[])valueListener));
            Node[] goLeft = zoomLabel;
            Node[] it5 = it4 = new Button();
            boolean bl3 = false;
            it5.setGraphic((Node)new FontIcon((Ikon)MaterialDesignC.CHEVRON_RIGHT));
            it5.setTooltip(new Tooltip("Show next page"));
            it5.setOnAction(arg_0 -> PDFViewSkin.createToolBar$lambda$36$lambda$34(view, arg_0));
            objectArray = new String[]{"tool-bar-button", "next-page-button"};
            it5.getStyleClass().addAll(objectArray);
            objectArray = new Observable[]{view.pageProperty(), view.documentProperty()};
            it5.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> PDFViewSkin.createToolBar$lambda$36$lambda$35(view), (Observable[])objectArray));
            goRight = it4;
            it = it5 = new TextField();
            boolean bl4 = false;
            it.setTooltip(new Tooltip("Current page number"));
            it.getStyleClass().add((Object)"page-field");
            it.maxHeightProperty().bind((ObservableValue)goLeft.heightProperty());
            it.setAlignment(Pos.CENTER);
            this.updateCurrentPageNumber(view, (TextField)it);
            Node[] pageField = it5;
            view.pageProperty().addListener(arg_0 -> PDFViewSkin.createToolBar$lambda$38(this, view, (TextField)pageField, arg_0));
            pageField.textProperty().addListener((arg_0, arg_1, arg_2) -> PDFViewSkin.createToolBar$lambda$41((arg_0, arg_1, arg_2) -> PDFViewSkin.createToolBar$lambda$40(view, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
            Node[] it6 = it = new Button();
            boolean bl5 = false;
            it6.setTooltip(new Tooltip("Total number of pages"));
            it6.getStyleClass().add((Object)"page-number-button");
            it6.maxHeightProperty().bind((ObservableValue)goLeft.heightProperty());
            it6.setAlignment(Pos.CENTER);
            it6.setOnAction(arg_0 -> PDFViewSkin.createToolBar$lambda$43$lambda$42(view, arg_0));
            it6.setFocusTraversable(false);
            this.updateTotalPagesNumber((Button)it6);
            Node[] totalPages = it;
            view.documentProperty().addListener((arg_0, arg_1, arg_2) -> PDFViewSkin.createToolBar$lambda$45((arg_0, arg_1, arg_2) -> PDFViewSkin.createToolBar$lambda$44(this, (Button)totalPages, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
            it = new Node[]{goLeft, pageField, totalPages, goRight};
            HBox $this$createToolBar_u24lambda_u2446 = new HBox(it);
            boolean bl6 = false;
            $this$createToolBar_u24lambda_u2446.setFillHeight(true);
            $this$createToolBar_u24lambda_u2446.disableProperty().bind((ObservableValue)view.documentProperty().isNull());
            $this$createToolBar_u24lambda_u2446.getStyleClass().add((Object)"page-control");
            $this$createToolBar_u24lambda_u2446.setAlignment(Pos.CENTER_LEFT);
            nodes.add($this$createToolBar_u24lambda_u2446);
            nodes.add(new Separator(Orientation.VERTICAL));
        }
        if (config.getRotation()) {
            Button it7 = goRight = new Button();
            boolean bl = false;
            it = new String[]{"tool-bar-button", "rotate-left"};
            it7.getStyleClass().addAll(it);
            it7.setTooltip(new Tooltip("Rotate page left"));
            it7.setGraphic((Node)new FontIcon((Ikon)MaterialDesignR.ROTATE_LEFT));
            it7.setOnAction(arg_0 -> PDFViewSkin.createToolBar$lambda$48$lambda$47(view, arg_0));
            Button rotateLeft = goRight;
            Button it8 = it7 = new Button();
            boolean bl7 = false;
            objectArray = new String[]{"tool-bar-button", "rotate-right"};
            it8.getStyleClass().addAll(objectArray);
            it8.setTooltip(new Tooltip("Rotate page right"));
            it8.setGraphic((Node)new FontIcon((Ikon)MaterialDesignR.ROTATE_RIGHT));
            it8.setOnAction(arg_0 -> PDFViewSkin.createToolBar$lambda$50$lambda$49(view, arg_0));
            Button rotateRight = it7;
            nodes.add(rotateLeft);
            nodes.add(rotateRight);
        }
        Collection $this$toTypedArray$iv = nodes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Node[] nodeArray = thisCollection$iv.toArray(new Node[0]);
        return new ToolBar(Arrays.copyOf(nodeArray, nodeArray.length));
    }

    private final void updateCurrentPageNumber(PDFView view, TextField pageField) {
        Object object = view;
        if (object != null && (object = object.getDocument()) != null) {
            Object it = object;
            boolean bl = false;
            pageField.setText(String.valueOf(view.getPage() + 1));
        } else {
            Function0 cfr_ignored_0 = () -> PDFViewSkin.updateCurrentPageNumber$lambda$52(pageField);
        }
    }

    private final void updateTotalPagesNumber(Button totalPagesButton) {
        Object object = (PDFView)this.getSkinnable();
        if (object != null && (object = object.getDocument()) != null) {
            PDFView it = object;
            boolean bl = false;
            totalPagesButton.setText("/ " + it.getNumberOfPages());
        } else {
            Function0 cfr_ignored_0 = () -> PDFViewSkin.updateTotalPagesNumber$lambda$54(totalPagesButton);
        }
    }

    private static final ListCell lambda$8$lambda$0(PDFViewSkin this$0, ListView listView) {
        return new ThumbnailListCell(this$0);
    }

    private static final Unit lambda$8$lambda$2(PDFViewSkin this$0, ObservableValue observableValue, PageKey pageKey, PageKey s) {
        block0: {
            PageKey pageKey2 = s;
            if (pageKey2 == null) break block0;
            PageKey it = pageKey2;
            boolean bl = false;
            this$0.view.setPage(it.getPageNumber());
        }
        return Unit.INSTANCE;
    }

    private static final void lambda$8$lambda$3(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void lambda$8$lambda$4(ListView $this_with, PDFViewSkin this$0, Observable observable) {
        $this_with.getSelectionModel().select(this$0.view.getPage());
        UtilsKt.maybeScrollTo($this_with, $this_with.getSelectionModel().getSelectedItem());
    }

    private static final Unit lambda$8$lambda$6(ListView $this_with, ObservableValue observableValue, ObservableList observableList, ObservableList n) {
        block0: {
            ObservableList observableList2 = n;
            if (observableList2 == null) break block0;
            ObservableList it = observableList2;
            boolean bl = false;
            $this_with.getSelectionModel().select(0);
        }
        return Unit.INSTANCE;
    }

    private static final void lambda$8$lambda$7(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit _init_$lambda$15(PDFViewSkin this$0, ListView $thumbnailListView, ObservableValue observableValue, Document document, Document n) {
        block0: {
            Document document2 = n;
            if (document2 == null) break block0;
            Document it = document2;
            boolean bl = false;
            this$0.resetThumbnailWidth = true;
            $thumbnailListView.setItems(it.getPagesList());
            $thumbnailListView.refresh();
            this$0.mainArea.reload();
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$16(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit _init_$lambda$18(PDFViewSkin this$0, ObservableValue observableValue, Number o, Number n) {
        this$0.switchViewport(o.intValue(), n.intValue());
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$19(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit _init_$lambda$20(PDFViewSkin this$0, ObservableValue observableValue, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this$0.switchViewport(null, this$0.view.getPage());
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$21(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void createToolBar$lambda$30$lambda$27(ObservableValue observableValue, Number number, Number number2) {
    }

    private static final void createToolBar$lambda$30$lambda$28(PDFView $view, Ref.ObjectRef $zoomListener, ObservableValue observableValue, Number number, Number newValue) {
        $view.zoomFactorProperty().removeListener((ChangeListener)$zoomListener.element);
        $view.setFitHorizontal(false);
        $view.setFitVertical(false);
        $view.setZoomFactor(newValue.doubleValue());
        $view.zoomFactorProperty().addListener((ChangeListener)$zoomListener.element);
    }

    private static final void createToolBar$lambda$30$lambda$29(Slider $this_with, ChangeListener $valueListener, ObservableValue observableValue, Number number, Number n) {
        $this_with.valueProperty().removeListener($valueListener);
        $this_with.setValue(n.doubleValue());
        $this_with.valueProperty().addListener($valueListener);
    }

    private static final void createToolBar$lambda$33$lambda$31(PDFView $view, ActionEvent actionEvent) {
        $view.gotoPreviousPage();
    }

    private static final Boolean createToolBar$lambda$33$lambda$32(PDFView $view) {
        return $view.getPage() <= 0;
    }

    private static final void createToolBar$lambda$36$lambda$34(PDFView $view, ActionEvent actionEvent) {
        $view.gotoNextPage();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Boolean createToolBar$lambda$36$lambda$35(PDFView $view) {
        boolean bl;
        if ($view.getDocument() != null) {
            Document document = $view.getDocument();
            Intrinsics.checkNotNull((Object)document);
            if (document.getNumberOfPages() > $view.getPage() + 1) {
                bl = false;
                return bl;
            }
        }
        bl = true;
        return bl;
    }

    private static final void createToolBar$lambda$38(PDFViewSkin this$0, PDFView $view, TextField $pageField, Observable observable) {
        this$0.updateCurrentPageNumber($view, $pageField);
    }

    private static final Unit createToolBar$lambda$40(PDFView $view, ObservableValue observableValue, String string, String n) {
        try {
            String string2 = n;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                $view.setPage(Integer.parseInt(it) - 1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Unit.INSTANCE;
    }

    private static final void createToolBar$lambda$41(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void createToolBar$lambda$43$lambda$42(PDFView $view, ActionEvent actionEvent) {
        $view.gotoLastPage();
    }

    private static final Unit createToolBar$lambda$44(PDFViewSkin this$0, Button $totalPages, ObservableValue observableValue, Document document, Document document2) {
        this$0.updateTotalPagesNumber($totalPages);
        return Unit.INSTANCE;
    }

    private static final void createToolBar$lambda$45(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void createToolBar$lambda$48$lambda$47(PDFView $view, ActionEvent actionEvent) {
        $view.rotateLeft();
    }

    private static final void createToolBar$lambda$50$lambda$49(PDFView $view, ActionEvent actionEvent) {
        $view.rotateRight();
    }

    private static final Unit updateCurrentPageNumber$lambda$52(TextField $pageField) {
        $pageField.setText("0");
        return Unit.INSTANCE;
    }

    private static final Unit updateTotalPagesNumber$lambda$54(Button $totalPagesButton) {
        $totalPagesButton.setText("/ 0");
        return Unit.INSTANCE;
    }
}

