/*
 * Decompiled with CFR 0.152.
 */
package de.confinitum.pdfview.base;

import de.confinitum.pdfview.PDFView;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ListView;
import javafx.scene.control.skin.VirtualFlow;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a'\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\n\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\u000b\"\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"executor", "Ljava/util/concurrent/Executor;", "getExecutor", "multi", "", "maybeScrollTo", "", "T", "listView", "Ljavafx/scene/control/ListView;", "item", "(Ljavafx/scene/control/ListView;Ljava/lang/Object;)V", "kpdfx"})
public final class UtilsKt {
    @Nullable
    private static Executor executor;

    @NotNull
    public static final Executor getExecutor(boolean multi) {
        if (executor == null) {
            executor = multi ? (Executor)Executors.newCachedThreadPool(UtilsKt::getExecutor$lambda$0) : (Executor)Executors.newSingleThreadExecutor(UtilsKt::getExecutor$lambda$1);
        }
        Executor executor = UtilsKt.executor;
        Intrinsics.checkNotNull((Object)executor);
        return executor;
    }

    public static final <T> void maybeScrollTo(@NotNull ListView<T> listView, T item) {
        Intrinsics.checkNotNullParameter(listView, (String)"listView");
        VirtualFlow virtualFlow = (VirtualFlow)listView.lookup("VirtualFlow");
        if (virtualFlow != null) {
            IndexedCell firstVisibleCell = virtualFlow.getFirstVisibleCell();
            IndexedCell lastVisibleCell = virtualFlow.getLastVisibleCell();
            if (firstVisibleCell != null && lastVisibleCell != null) {
                int start = Math.max(0, firstVisibleCell.getIndex() + 1);
                int end = Math.max(1, lastVisibleCell.getIndex() - 1);
                int index = listView.getItems().indexOf(item);
                if (index < start || index > end) {
                    listView.scrollTo(item);
                }
            }
        }
    }

    private static final Thread getExecutor$lambda$0(Runnable r) {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        return thread;
    }

    private static final Thread getExecutor$lambda$1(Runnable r) {
        Thread thread = new Thread(r, PDFView.class.getSimpleName() + " Thread");
        thread.setDaemon(true);
        return thread;
    }
}

