/*
 * Decompiled with CFR 0.152.
 */
package de.confinitum.pdfview.base;

import de.confinitum.pdfview.PDFView;
import de.confinitum.pdfview.base.Document;
import de.confinitum.pdfview.skin.PDFViewSkin;
import java.awt.image.BufferedImage;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\n\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0014J*\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lde/confinitum/pdfview/base/RenderTask;", "Ljavafx/concurrent/Task;", "Ljavafx/scene/image/Image;", "pdfViewSkin", "Lde/confinitum/pdfview/skin/PDFViewSkin;", "thumbnail", "", "page", "", "scale", "", "rotation", "", "<init>", "(Lde/confinitum/pdfview/skin/PDFViewSkin;ZIFD)V", "getPdfViewSkin", "()Lde/confinitum/pdfview/skin/PDFViewSkin;", "getThumbnail", "()Z", "getPage", "()I", "getScale", "()F", "getRotation", "()D", "call", "renderPDFPage", "pageNumber", "useCache", "kpdfx"})
public final class RenderTask
extends Task<Image> {
    @NotNull
    private final PDFViewSkin pdfViewSkin;
    private final boolean thumbnail;
    private final int page;
    private final float scale;
    private final double rotation;

    public RenderTask(@NotNull PDFViewSkin pdfViewSkin, boolean thumbnail, int page2, float scale, double rotation) {
        Intrinsics.checkNotNullParameter((Object)((Object)pdfViewSkin), (String)"pdfViewSkin");
        this.pdfViewSkin = pdfViewSkin;
        this.thumbnail = thumbnail;
        this.page = page2;
        this.scale = scale;
        this.rotation = rotation;
    }

    @NotNull
    public final PDFViewSkin getPdfViewSkin() {
        return this.pdfViewSkin;
    }

    public final boolean getThumbnail() {
        return this.thumbnail;
    }

    public final int getPage() {
        return this.page;
    }

    public final float getScale() {
        return this.scale;
    }

    public final double getRotation() {
        return this.rotation;
    }

    @Nullable
    protected Image call() {
        PDFView pdfView = (PDFView)this.pdfViewSkin.getSkinnable();
        if (this.page >= 0) {
            Document document = pdfView.getDocument();
            if (this.page < (document != null ? document.getNumberOfPages() : 0)) {
                return this.renderPDFPage(this.page, this.scale, this.rotation, pdfView.isCacheThumbnails() && this.thumbnail);
            }
        }
        return null;
    }

    private final Image renderPDFPage(int pageNumber, float scale, double rotation, boolean useCache) {
        BufferedImage bufferedImage;
        Document document = ((PDFView)this.pdfViewSkin.getSkinnable()).getDocument();
        BufferedImage bufferedImage2 = bufferedImage = document != null ? document.renderPage(pageNumber, scale, rotation, useCache) : null;
        if (this.isCancelled() || bufferedImage == null) {
            return null;
        }
        return (Image)SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
    }
}

