/*
 * Decompiled with CFR 0.152.
 */
package de.confinitum.pdfview.base;

import de.confinitum.pdfview.base.Document;
import de.confinitum.pdfview.base.PageKey;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.rendering.RenderDestination;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0001(B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020!H\u0016J\b\u0010&\u001a\u00020\u0014H\u0016J\b\u0010'\u001a\u00020\u0014H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u001d\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006)"}, d2={"Lde/confinitum/pdfview/base/PDFBoxDocument;", "Lde/confinitum/pdfview/base/Document;", "pdfInputStream", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "document", "Lorg/apache/pdfbox/pdmodel/PDDocument;", "imageCache", "", "Lde/confinitum/pdfview/base/PageKey;", "Ljava/awt/image/BufferedImage;", "pagesList", "Ljavafx/collections/ObservableList;", "getPagesList", "()Ljavafx/collections/ObservableList;", "setPageRotation", "", "pageNumber", "", "rotationAngle", "", "getPageRotation", "setViewport", "viewport", "Ljavafx/geometry/Rectangle2D;", "numberOfPages", "getNumberOfPages", "()I", "isLandscape", "", "renderPage", "scale", "", "useCache", "close", "updatePagesList", "Companion", "kpdfx"})
@SourceDebugExtension(value={"SMAP\nDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Document.kt\nde/confinitum/pdfview/base/PDFBoxDocument\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1563#2:174\n1634#2,3:175\n*S KotlinDebug\n*F\n+ 1 Document.kt\nde/confinitum/pdfview/base/PDFBoxDocument\n*L\n168#1:174\n168#1:175,3\n*E\n"})
public final class PDFBoxDocument
implements Document {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PDDocument document;
    @NotNull
    private final Map<PageKey, BufferedImage> imageCache;
    @NotNull
    private final ObservableList<PageKey> pagesList;
    public static final double DPI = 72.0;

    public PDFBoxDocument(@Nullable InputStream pdfInputStream) {
        this.imageCache = new LinkedHashMap();
        ObservableList observableList = FXCollections.observableArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"observableArrayList(...)");
        this.pagesList = observableList;
        PDDocument pDDocument = PDDocument.load((InputStream)pdfInputStream);
        Intrinsics.checkNotNullExpressionValue((Object)pDDocument, (String)"load(...)");
        this.document = pDDocument;
        this.updatePagesList();
    }

    @Override
    @NotNull
    public ObservableList<PageKey> getPagesList() {
        return this.pagesList;
    }

    public PDFBoxDocument(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(new FileInputStream(file));
    }

    @Override
    public void setPageRotation(int pageNumber, double rotationAngle) {
        PageKey pageKey = (PageKey)this.getPagesList().get(pageNumber);
        this.getPagesList().set(pageNumber, (Object)PageKey.copy$default(pageKey, pageNumber, rotationAngle, null, 4, null));
    }

    @Override
    @NotNull
    public PageKey getPageRotation(int pageNumber) {
        Object object = this.getPagesList().get(pageNumber);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (PageKey)object;
    }

    @Override
    public void setViewport(int pageNumber, @Nullable Rectangle2D viewport) {
        block0: {
            PageKey pageKey = (PageKey)CollectionsKt.getOrNull((List)((List)this.getPagesList()), (int)pageNumber);
            if (pageKey == null) break block0;
            PageKey it = pageKey;
            boolean bl = false;
            PageKey cfr_ignored_0 = (PageKey)this.getPagesList().set(pageNumber, (Object)PageKey.copy$default(it, 0, 0.0, viewport, 3, null));
        }
    }

    @Override
    public int getNumberOfPages() {
        return this.document.getNumberOfPages();
    }

    @Override
    public boolean isLandscape(int pageNumber) {
        PDPage page2 = this.document.getPage(pageNumber);
        double rotationAngle = ((PageKey)this.getPagesList().get(pageNumber)).getRotationAngle();
        PDRectangle cropBox = page2.getCropBox();
        return rotationAngle % (double)180 == 0.0 ? cropBox.getHeight() < cropBox.getWidth() : cropBox.getWidth() < cropBox.getHeight();
    }

    @Override
    @NotNull
    public BufferedImage renderPage(int pageNumber, float scale, double rotationAngle, boolean useCache) {
        BufferedImage image;
        BufferedImage bufferedImage = image = useCache ? this.imageCache.get(new PageKey(pageNumber, rotationAngle, null, 4, null)) : null;
        if (image == null) {
            this.document.getPage(pageNumber).setRotation((int)rotationAngle);
            PDFRenderer renderer = new PDFRenderer(this.document);
            image = renderer.renderImage(pageNumber, scale, ImageType.ARGB, RenderDestination.VIEW);
            if (useCache) {
                this.imageCache.put(new PageKey(pageNumber, rotationAngle, null, 4, null), image);
            }
        }
        BufferedImage bufferedImage2 = image;
        Intrinsics.checkNotNull(bufferedImage2);
        return bufferedImage2;
    }

    @Override
    public void close() {
        this.document.close();
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePagesList() {
        void $this$mapTo$iv$iv;
        IntRange pages = RangesKt.until((int)0, (int)this.document.getNumberOfPages());
        Iterable $this$map$iv = (Iterable)pages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PageKey((int)it, 0.0, null, 4, null));
        }
        List pageKeys = (List)destination$iv$iv;
        this.getPagesList().addAll((Collection)pageKeys);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/confinitum/pdfview/base/PDFBoxDocument$Companion;", "", "<init>", "()V", "DPI", "", "kpdfx"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

