/*
 * Decompiled with CFR 0.152.
 */
package de.confinitum.pdfview;

import de.confinitum.pdfview.base.Document;
import de.confinitum.pdfview.base.PDFBoxDocument;
import de.confinitum.pdfview.base.PageKey;
import de.confinitum.pdfview.base.ToolbarConfig;
import de.confinitum.pdfview.base.UtilsKt;
import de.confinitum.pdfview.skin.PDFViewSkin;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\f\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0013J\u0006\u0010\u001a\u001a\u00020\u0016J\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0016J\u0006\u0010\u001c\u001a\u00020\u0013J\u0006\u0010\u001e\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0016J\u0006\u0010 \u001a\u00020!J\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020$J\u0006\u0010&\u001a\u00020!J\u0006\u0010(\u001a\u00020$J\u000e\u0010)\u001a\u00020\u00102\u0006\u0010'\u001a\u00020$J\u0006\u0010*\u001a\u00020!J\u0006\u0010,\u001a\u00020$J\u000e\u0010-\u001a\u00020\u00102\u0006\u0010+\u001a\u00020$J\u0006\u0010.\u001a\u00020!J\u0006\u00100\u001a\u00020$J\u000e\u00101\u001a\u00020\u00102\u0006\u0010/\u001a\u00020$J\u0006\u00102\u001a\u00020\u0010J\u0006\u00103\u001a\u00020\u0010J\u0006\u00104\u001a\u000205J\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020\u00102\u0006\u00106\u001a\u000208J\u0006\u0010:\u001a\u00020\u0016J\u0006\u0010;\u001a\u00020\u0016J\u0006\u0010<\u001a\u00020\u0016J\u0006\u0010=\u001a\u00020\u0013J\u0006\u0010?\u001a\u00020\u0016J\u000e\u0010@\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u0016J\u0006\u0010A\u001a\u00020\u0013J\u0006\u0010C\u001a\u00020\u0016J\u000e\u0010D\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\u0016J\u0006\u0010E\u001a\u00020FJ\u0006\u0010H\u001a\u00020IJ\u000e\u0010J\u001a\u00020\u00102\u0006\u0010G\u001a\u00020IJ\u0006\u0010K\u001a\u00020FJ\u0006\u0010M\u001a\u00020IJ\u000e\u0010N\u001a\u00020\u00102\u0006\u0010L\u001a\u00020IJ\u0006\u0010O\u001a\u00020!J\u0006\u0010Q\u001a\u00020$J\u000e\u0010R\u001a\u00020\u00102\u0006\u0010P\u001a\u00020$J\u000e\u0010S\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010T0\fJ\b\u0010V\u001a\u0004\u0018\u00010TJ\u0010\u0010W\u001a\u00020\u00102\b\u0010U\u001a\u0004\u0018\u00010TJ\u0006\u0010X\u001a\u00020\u0013J\u0006\u0010Z\u001a\u00020\u0016J\u000e\u0010[\u001a\u00020\u00102\u0006\u0010\\\u001a\u00020\u0016J\u0006\u0010]\u001a\u00020^J\u000e\u0010_\u001a\u00020\u00102\u0006\u0010`\u001a\u00020aJ\u000e\u0010_\u001a\u00020\u00102\u0006\u0010b\u001a\u00020cJ\u0014\u0010_\u001a\u00020\u00102\f\u0010d\u001a\b\u0012\u0004\u0012\u00020T0eJ\u0006\u0010f\u001a\u00020\u0010R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010U\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010T0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lde/confinitum/pdfview/PDFView;", "Ljavafx/scene/control/Control;", "toolbarConfiguration", "Lde/confinitum/pdfview/base/ToolbarConfig;", "<init>", "(Lde/confinitum/pdfview/base/ToolbarConfig;)V", "()V", "createDefaultSkin", "Ljavafx/scene/control/Skin;", "getUserAgentStylesheet", "", "toolbarConfigProperty", "Ljavafx/beans/property/ObjectProperty;", "toolbarConfig", "getToolbarConfig", "setToolbarConfig", "", "config", "showThumbnailsProperty", "Ljavafx/beans/property/BooleanProperty;", "showThumbnails", "isShowThumbnails", "", "setShowThumbnails", "showToolBarProperty", "showToolBar", "isShowToolBar", "setShowToolBar", "cacheThumbnailsProperty", "cacheThumbnails", "isCacheThumbnails", "setCacheThumbnails", "minZoomFactorProperty", "Ljavafx/beans/property/DoubleProperty;", "minZoomFactor", "getMinZoomFactor", "", "setMinZoomFactor", "maxZoomFactorProperty", "maxZoomFactor", "getMaxZoomFactor", "setMaxZoomFactor", "zoomFactorProperty", "zoomFactor", "getZoomFactor", "setZoomFactor", "pageRotationProperty", "pageRotation", "getPageRotation", "setPageRotation", "rotateLeft", "rotateRight", "pageProperty", "Ljavafx/beans/property/IntegerProperty;", "page", "getPage", "", "setPage", "gotoNextPage", "gotoPreviousPage", "gotoLastPage", "fitVerticalProperty", "fitVertical", "isFitVertical", "setFitVertical", "fitHorizontalProperty", "fitHorizontal", "isFitHorizontal", "setFitHorizontal", "thumbnailRenderDpiProperty", "Ljavafx/beans/property/FloatProperty;", "thumbnailRenderDpi", "getThumbnailRenderDpi", "", "setThumbnailRenderDpi", "pageRenderDpiProperty", "pageRenderDpi", "getPageRenderDpi", "setPageRenderDpi", "thumbnailSizeProperty", "thumbnailSize", "getThumbnailSize", "setThumbnailSize", "documentProperty", "Lde/confinitum/pdfview/base/Document;", "document", "getDocument", "setDocument", "multiThreadRenderingProperty", "multiThreadRendering", "getMultiThreadRendering", "setMultiThreadRendering", "value", "getRenderExecutor", "Ljava/util/concurrent/Executor;", "load", "file", "Ljava/io/File;", "stream", "Ljava/io/InputStream;", "supplier", "Ljava/util/function/Supplier;", "unload", "kpdfx"})
public final class PDFView
extends Control {
    @NotNull
    private final ObjectProperty<ToolbarConfig> toolbarConfig;
    @NotNull
    private final BooleanProperty showThumbnails;
    @NotNull
    private final BooleanProperty showToolBar;
    @NotNull
    private final BooleanProperty cacheThumbnails;
    @NotNull
    private final DoubleProperty minZoomFactor;
    @NotNull
    private final DoubleProperty maxZoomFactor;
    @NotNull
    private final DoubleProperty zoomFactor;
    @NotNull
    private final DoubleProperty pageRotation;
    @NotNull
    private final IntegerProperty page;
    @NotNull
    private final BooleanProperty fitVertical;
    @NotNull
    private final BooleanProperty fitHorizontal;
    @NotNull
    private final FloatProperty thumbnailRenderDpi;
    @NotNull
    private final FloatProperty pageRenderDpi;
    @NotNull
    private final DoubleProperty thumbnailSize;
    @NotNull
    private final ObjectProperty<Document> document;
    @NotNull
    private final BooleanProperty multiThreadRendering;

    public PDFView(@NotNull ToolbarConfig toolbarConfiguration) {
        Intrinsics.checkNotNullParameter((Object)toolbarConfiguration, (String)"toolbarConfiguration");
        this.toolbarConfig = (ObjectProperty)new SimpleObjectProperty((Object)this, "toolbarConfig", (Object)new ToolbarConfig());
        this.showThumbnails = (BooleanProperty)new SimpleBooleanProperty((Object)this, "showThumbnails", true);
        this.showToolBar = (BooleanProperty)new SimpleBooleanProperty((Object)this, "showToolBar", true);
        this.cacheThumbnails = (BooleanProperty)new SimpleBooleanProperty((Object)this, "cacheThumbnails", true);
        this.minZoomFactor = (DoubleProperty)new SimpleDoubleProperty((Object)this, "minZoomFactor", 0.2);
        this.maxZoomFactor = (DoubleProperty)new SimpleDoubleProperty((Object)this, "maxZoomFactor", 3.0);
        this.zoomFactor = (DoubleProperty)new SimpleDoubleProperty(this){
            final /* synthetic */ PDFView this$0;
            {
                this.this$0 = $receiver;
                super((Object)((Object)$receiver), "zoomFactor", 1.0);
            }

            public void set(double newValue) {
                super.set(Math.min(Math.max(newValue, this.this$0.getMinZoomFactor()), this.this$0.getMaxZoomFactor()));
            }
        };
        this.pageRotation = (DoubleProperty)new SimpleDoubleProperty(this){
            final /* synthetic */ PDFView this$0;
            {
                this.this$0 = $receiver;
                super((Object)((Object)$receiver), "pageRotation", 0.0);
            }

            public void set(double newValue) {
                block2: {
                    double rotation = Math.floor(newValue / (double)90) * (double)90;
                    if (rotation < 0.0) {
                        rotation += (double)360;
                    }
                    if (rotation >= 360.0) {
                        rotation -= (double)360;
                    }
                    super.set(rotation % 360.0);
                    Document document = this.this$0.getDocument();
                    if (document == null) break block2;
                    document.setPageRotation(this.this$0.getPage(), rotation);
                }
            }
        };
        this.page = (IntegerProperty)new SimpleIntegerProperty(this){
            final /* synthetic */ PDFView this$0;
            {
                this.this$0 = $receiver;
                super((Object)((Object)$receiver), "page");
            }

            public void set(int newValue) {
                block0: {
                    super.set(newValue);
                    Object object = this.this$0.getDocument();
                    if (object == null || (object = object.getPageRotation(newValue)) == null) break block0;
                    Object object2 = object;
                    PDFView pDFView = this.this$0;
                    Object it = object2;
                    boolean bl = false;
                    pDFView.setPageRotation(((PageKey)it).getRotationAngle());
                }
            }
        };
        this.fitVertical = (BooleanProperty)new SimpleBooleanProperty((Object)this, "fitVertical", false);
        this.fitHorizontal = (BooleanProperty)new SimpleBooleanProperty((Object)this, "fitHorizontal", false);
        this.thumbnailRenderDpi = (FloatProperty)new SimpleFloatProperty((Object)this, "thumbnailScale", 72.0f);
        this.pageRenderDpi = (FloatProperty)new SimpleFloatProperty((Object)this, "pageRenderDpi", 300.0f);
        this.thumbnailSize = (DoubleProperty)new SimpleDoubleProperty((Object)this, "thumbnailSize", 200.0);
        this.document = (ObjectProperty)new SimpleObjectProperty((Object)this, "document");
        this.multiThreadRendering = (BooleanProperty)new SimpleBooleanProperty((Object)this, "multiThreadRendering", false);
        this.setToolbarConfig(toolbarConfiguration);
        this.getStyleClass().add((Object)"pdf-view");
        this.setFocusTraversable(false);
        this.documentProperty().addListener((arg_0, arg_1, arg_2) -> PDFView._init_$lambda$1(PDFView::_init_$lambda$0, arg_0, arg_1, arg_2));
    }

    @NotNull
    protected Skin<?> createDefaultSkin() {
        return (Skin)new PDFViewSkin(this);
    }

    @NotNull
    public String getUserAgentStylesheet() {
        Object object = ((Object)((Object)this)).getClass().getResource("/pdf-view.css");
        if (object == null || (object = ((URL)object).toExternalForm()) == null) {
            throw new Exception("not found");
        }
        return object;
    }

    public PDFView() {
        this(new ToolbarConfig());
    }

    @NotNull
    public final ObjectProperty<ToolbarConfig> toolbarConfigProperty() {
        return this.toolbarConfig;
    }

    @NotNull
    public final ToolbarConfig getToolbarConfig() {
        Object object = this.toolbarConfig.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ToolbarConfig)object;
    }

    public final void setToolbarConfig(@NotNull ToolbarConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.toolbarConfig.set((Object)config);
    }

    @NotNull
    public final BooleanProperty showThumbnailsProperty() {
        return this.showThumbnails;
    }

    public final boolean isShowThumbnails() {
        return this.showThumbnails.get();
    }

    public final void setShowThumbnails(boolean showThumbnails) {
        this.showThumbnails.set(showThumbnails);
    }

    @NotNull
    public final BooleanProperty showToolBarProperty() {
        return this.showToolBar;
    }

    public final boolean isShowToolBar() {
        return this.showToolBar.get();
    }

    public final void setShowToolBar(boolean showToolBar) {
        this.showToolBar.set(showToolBar);
    }

    @NotNull
    public final BooleanProperty cacheThumbnailsProperty() {
        return this.cacheThumbnails;
    }

    public final boolean isCacheThumbnails() {
        return this.cacheThumbnails.get();
    }

    public final void setCacheThumbnails(boolean cacheThumbnails) {
        this.cacheThumbnails.set(cacheThumbnails);
    }

    @NotNull
    public final DoubleProperty minZoomFactorProperty() {
        return this.minZoomFactor;
    }

    public final double getMinZoomFactor() {
        return this.minZoomFactor.get();
    }

    public final void setMinZoomFactor(double minZoomFactor) {
        this.minZoomFactor.set(minZoomFactor);
    }

    @NotNull
    public final DoubleProperty maxZoomFactorProperty() {
        return this.maxZoomFactor;
    }

    public final double getMaxZoomFactor() {
        return this.maxZoomFactor.get();
    }

    public final void setMaxZoomFactor(double maxZoomFactor) {
        this.maxZoomFactor.set(maxZoomFactor);
    }

    @NotNull
    public final DoubleProperty zoomFactorProperty() {
        return this.zoomFactor;
    }

    public final double getZoomFactor() {
        return this.zoomFactor.get();
    }

    public final void setZoomFactor(double zoomFactor2) {
        this.zoomFactor.set(zoomFactor2);
    }

    @NotNull
    public final DoubleProperty pageRotationProperty() {
        return this.pageRotation;
    }

    public final double getPageRotation() {
        return this.pageRotation.get();
    }

    public final void setPageRotation(double pageRotation2) {
        this.pageRotation.set(pageRotation2);
    }

    public final void rotateLeft() {
        this.setPageRotation(this.getPageRotation() - (double)90);
    }

    public final void rotateRight() {
        this.setPageRotation(this.getPageRotation() + (double)90);
    }

    @NotNull
    public final IntegerProperty pageProperty() {
        return this.page;
    }

    public final int getPage() {
        return this.pageProperty().get();
    }

    public final void setPage(int page2) {
        this.pageProperty().set(page2);
    }

    public final boolean gotoNextPage() {
        int currentPage = this.getPage();
        Document document = this.getDocument();
        Intrinsics.checkNotNull((Object)document);
        this.setPage(Math.min(document.getNumberOfPages() - 1, this.getPage() + 1));
        return currentPage != this.getPage();
    }

    public final boolean gotoPreviousPage() {
        int currentPage = this.getPage();
        this.setPage(Math.max(0, this.getPage() - 1));
        return currentPage != this.getPage();
    }

    public final boolean gotoLastPage() {
        int currentPage = this.getPage();
        Document document = this.getDocument();
        Intrinsics.checkNotNull((Object)document);
        this.setPage(document.getNumberOfPages() - 1);
        return currentPage != this.getPage();
    }

    @NotNull
    public final BooleanProperty fitVerticalProperty() {
        return this.fitVertical;
    }

    public final boolean isFitVertical() {
        return this.fitVertical.get();
    }

    public final void setFitVertical(boolean fitVertical) {
        this.fitVertical.set(fitVertical);
    }

    @NotNull
    public final BooleanProperty fitHorizontalProperty() {
        return this.fitHorizontal;
    }

    public final boolean isFitHorizontal() {
        return this.fitHorizontal.get();
    }

    public final void setFitHorizontal(boolean fitHorizontal) {
        this.fitHorizontal.set(fitHorizontal);
    }

    @NotNull
    public final FloatProperty thumbnailRenderDpiProperty() {
        return this.thumbnailRenderDpi;
    }

    public final float getThumbnailRenderDpi() {
        return this.thumbnailRenderDpi.get();
    }

    public final void setThumbnailRenderDpi(float thumbnailRenderDpi) {
        this.thumbnailRenderDpi.set(thumbnailRenderDpi);
    }

    @NotNull
    public final FloatProperty pageRenderDpiProperty() {
        return this.pageRenderDpi;
    }

    public final float getPageRenderDpi() {
        return this.pageRenderDpi.get();
    }

    public final void setPageRenderDpi(float pageRenderDpi) {
        this.pageRenderDpi.set(pageRenderDpi);
    }

    @NotNull
    public final DoubleProperty thumbnailSizeProperty() {
        return this.thumbnailSize;
    }

    public final double getThumbnailSize() {
        return this.thumbnailSize.get();
    }

    public final void setThumbnailSize(double thumbnailSize) {
        this.thumbnailSize.set(thumbnailSize);
    }

    @NotNull
    public final ObjectProperty<Document> documentProperty() {
        return this.document;
    }

    @Nullable
    public final Document getDocument() {
        return (Document)this.document.get();
    }

    public final void setDocument(@Nullable Document document) {
        this.document.set((Object)document);
    }

    @NotNull
    public final BooleanProperty multiThreadRenderingProperty() {
        return this.multiThreadRendering;
    }

    public final boolean getMultiThreadRendering() {
        return this.multiThreadRendering.get();
    }

    public final void setMultiThreadRendering(boolean value) {
        this.multiThreadRendering.set(value);
    }

    @NotNull
    public final Executor getRenderExecutor() {
        return UtilsKt.getExecutor(this.getMultiThreadRendering());
    }

    public final void load(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.load(() -> PDFView.load$lambda$2(file));
    }

    public final void load(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.load(() -> PDFView.load$lambda$3(stream));
    }

    public final void load(@NotNull Supplier<Document> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        this.setDocument(supplier.get());
    }

    public final void unload() {
        this.setDocument(null);
        this.setZoomFactor(1.0);
        this.setRotate(0.0);
    }

    private static final Unit _init_$lambda$0(ObservableValue observableValue, Document oldDoc, Document document) {
        block0: {
            Document document2 = oldDoc;
            if (document2 == null) break block0;
            document2.close();
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Document load$lambda$2(File $file) {
        return new PDFBoxDocument($file);
    }

    private static final Document load$lambda$3(InputStream $stream) {
        return new PDFBoxDocument($stream);
    }
}

