/*
 * Decompiled with CFR 0.152.
 */
package de.confinitum.pdfview.skin;

import de.confinitum.pdfview.PDFView;
import de.confinitum.pdfview.base.Document;
import de.confinitum.pdfview.base.PageKey;
import de.confinitum.pdfview.base.RenderService;
import de.confinitum.pdfview.skin.PDFViewSkin;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u001a\u0010\u0013\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/confinitum/pdfview/skin/ThumbnailListCell;", "Ljavafx/scene/control/ListCell;", "Lde/confinitum/pdfview/base/PageKey;", "pdfViewSkin", "Lde/confinitum/pdfview/skin/PDFViewSkin;", "(Lde/confinitum/pdfview/skin/PDFViewSkin;)V", "dragstart", "Ljavafx/geometry/Point2D;", "imageView", "Ljavafx/scene/image/ImageView;", "pageNumberLabel", "Ljavafx/scene/control/Label;", "renderService", "Lde/confinitum/pdfview/base/RenderService;", "viewport", "Ljavafx/scene/shape/Rectangle;", "moveViewPort", "", "offset", "updateItem", "pageKey", "empty", "", "kpdfx"})
public final class ThumbnailListCell
extends ListCell<PageKey> {
    @NotNull
    private final PDFViewSkin pdfViewSkin;
    @NotNull
    private final ImageView imageView;
    @NotNull
    private final Rectangle viewport;
    @NotNull
    private final Label pageNumberLabel;
    @NotNull
    private final RenderService renderService;
    @NotNull
    private Point2D dragstart;

    public ThumbnailListCell(@NotNull PDFViewSkin pdfViewSkin) {
        Intrinsics.checkNotNullParameter((Object)((Object)pdfViewSkin), (String)"pdfViewSkin");
        this.pdfViewSkin = pdfViewSkin;
        this.imageView = new ImageView();
        this.viewport = new Rectangle();
        this.pageNumberLabel = new Label();
        this.renderService = new RenderService(this.pdfViewSkin, true, null, 4, null);
        this.dragstart = new Point2D(0.0, 0.0);
        this.imageView.setPreserveRatio(true);
        StackPane $this$_init__u24lambda_u240 = this.viewport;
        boolean bl = false;
        $this$_init__u24lambda_u240.setManaged(false);
        $this$_init__u24lambda_u240.setVisible(false);
        $this$_init__u24lambda_u240.getStyleClass().add((Object)"viewport-indicator");
        $this$_init__u24lambda_u240.setCursor(Cursor.OPEN_HAND);
        $this$_init__u24lambda_u240.setOnMousePressed(new EventHandler(this, (Rectangle)$this$_init__u24lambda_u240){
            final /* synthetic */ ThumbnailListCell this$0;
            final /* synthetic */ Rectangle $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
            }

            public final void handle(MouseEvent ev) {
                Point2D point2D = this.$this_with.sceneToLocal(ev.getSceneX(), ev.getSceneY());
                Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"sceneToLocal(...)");
                ThumbnailListCell.access$setDragstart$p(this.this$0, point2D);
                this.$this_with.setCursor(Cursor.CLOSED_HAND);
                ev.setDragDetect(true);
            }
        });
        $this$_init__u24lambda_u240.setOnMouseDragged(new EventHandler((Rectangle)$this$_init__u24lambda_u240, this){
            final /* synthetic */ Rectangle $this_with;
            final /* synthetic */ ThumbnailListCell this$0;
            {
                this.$this_with = $receiver;
                this.this$0 = $receiver2;
            }

            public final void handle(MouseEvent ev) {
                Point2D sceneToLocal = this.$this_with.sceneToLocal(ev.getSceneX(), ev.getSceneY());
                Point2D drag = sceneToLocal.subtract(ThumbnailListCell.access$getDragstart$p(this.this$0));
                Intrinsics.checkNotNull((Object)sceneToLocal);
                ThumbnailListCell.access$setDragstart$p(this.this$0, sceneToLocal);
                Intrinsics.checkNotNull((Object)drag);
                ThumbnailListCell.access$moveViewPort(this.this$0, drag);
            }
        });
        $this$_init__u24lambda_u240.setOnMouseReleased(new EventHandler((Rectangle)$this$_init__u24lambda_u240, this){
            final /* synthetic */ Rectangle $this_with;
            final /* synthetic */ ThumbnailListCell this$0;
            {
                this.$this_with = $receiver;
                this.this$0 = $receiver2;
            }

            public final void handle(MouseEvent mouseEvent) {
                this.$this_with.setCursor(Cursor.OPEN_HAND);
                Rectangle2D vp = new Rectangle2D(ThumbnailListCell.access$getViewport$p(this.this$0).getX() / ThumbnailListCell.access$getImageView$p(this.this$0).getLayoutBounds().getWidth(), ThumbnailListCell.access$getViewport$p(this.this$0).getY() / ThumbnailListCell.access$getImageView$p(this.this$0).getLayoutBounds().getHeight(), ThumbnailListCell.access$getViewport$p(this.this$0).getWidth() / ThumbnailListCell.access$getImageView$p(this.this$0).getLayoutBounds().getWidth(), ThumbnailListCell.access$getViewport$p(this.this$0).getHeight() / ThumbnailListCell.access$getImageView$p(this.this$0).getLayoutBounds().getHeight());
                ThumbnailListCell.access$getPdfViewSkin$p(this.this$0).setViewport(vp);
            }
        });
        $this$_init__u24lambda_u240 = new StackPane[]{this.imageView, this.viewport};
        StackPane it = $this$_init__u24lambda_u240 = new StackPane((Node[])$this$_init__u24lambda_u240);
        boolean bl2 = false;
        it.getStyleClass().add((Object)"image-view-wrapper");
        it.setMaxWidth(Double.NEGATIVE_INFINITY);
        it.visibleProperty().bind((ObservableValue)this.imageView.imageProperty().isNotNull());
        StackPane stackPane = $this$_init__u24lambda_u240;
        VBox $this$_init__u24lambda_u242 = this.pageNumberLabel;
        boolean bl3 = false;
        $this$_init__u24lambda_u242.getStyleClass().add((Object)"page-number-label");
        $this$_init__u24lambda_u242.visibleProperty().bind((ObservableValue)this.imageView.imageProperty().isNotNull());
        $this$_init__u24lambda_u242 = new VBox[]{stackPane, this.pageNumberLabel};
        VBox it2 = $this$_init__u24lambda_u242 = new VBox(5.0, (Node[])$this$_init__u24lambda_u242);
        boolean bl4 = false;
        it2.setAlignment(Pos.CENTER);
        it2.setFillWidth(true);
        it2.visibleProperty().bind((ObservableValue)this.emptyProperty().not());
        VBox vBox = $this$_init__u24lambda_u242;
        this.setGraphic((Node)vBox);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.setAlignment(Pos.CENTER);
        ChangeListener itemListener = (arg_0, arg_1, arg_2) -> ThumbnailListCell._init_$lambda$4(this, arg_0, arg_1, arg_2);
        this.itemProperty().addListener(itemListener);
        RenderService $this$_init__u24lambda_u246 = this.renderService;
        boolean bl5 = false;
        $this$_init__u24lambda_u246.scaleProperty().bind((ObservableValue)((PDFView)$this$_init__u24lambda_u246.getPdfViewSkin().getSkinnable()).thumbnailRenderDpiProperty().divide(72.0));
        $this$_init__u24lambda_u246.valueProperty().addListener((arg_0, arg_1, arg_2) -> ThumbnailListCell.lambda$6$lambda$5((Function3)new Function3<ObservableValue<? extends Image>, Image, Image, Unit>(this){
            final /* synthetic */ ThumbnailListCell this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(ObservableValue<? extends Image> observableValue, Image image, Image image2) {
                ThumbnailListCell.access$getImageView$p(this.this$0).setImage(image2);
            }
        }, arg_0, arg_1, arg_2));
        this.imageView.boundsInParentProperty().addListener((arg_0, arg_1, arg_2) -> ThumbnailListCell._init_$lambda$7((Function3)new Function3<ObservableValue<? extends Bounds>, Bounds, Bounds, Unit>(){

            public final void invoke(ObservableValue<? extends Bounds> observableValue, Bounds bounds, Bounds w) {
                block1: {
                    Bounds bounds2 = w;
                    if (bounds2 == null) break block1;
                    Bounds bounds3 = bounds2;
                    ThumbnailListCell thumbnailListCell = this;
                    Bounds it = bounds3;
                    boolean bl = false;
                    if (thumbnailListCell.imageView.imageProperty().isNotNull().get()) {
                        thumbnailListCell.pdfViewSkin.registerThumbnailWidth(w.getWidth());
                    }
                }
            }
        }, arg_0, arg_1, arg_2));
    }

    protected void updateItem(@Nullable PageKey pageKey, boolean empty) {
        super.updateItem((Object)pageKey, empty);
        if (pageKey != null && !empty) {
            Document document = ((PDFView)this.pdfViewSkin.getSkinnable()).getDocument();
            boolean bl = document != null ? document.isLandscape(pageKey.getPageNumber()) : false;
            if (bl) {
                this.imageView.fitHeightProperty().unbind();
                this.imageView.fitWidthProperty().bind((ObservableValue)((PDFView)this.pdfViewSkin.getSkinnable()).thumbnailSizeProperty());
            } else {
                this.imageView.fitWidthProperty().unbind();
                this.imageView.fitHeightProperty().bind((ObservableValue)((PDFView)this.pdfViewSkin.getSkinnable()).thumbnailSizeProperty());
            }
            this.pageNumberLabel.setText(String.valueOf(pageKey.getPageNumber() + 1));
        }
    }

    private final void moveViewPort(Point2D offset) {
        double x = this.viewport.getX() + offset.getX();
        double y = this.viewport.getY() + offset.getY();
        double mx = this.imageView.getLayoutBounds().getWidth() - this.viewport.getWidth();
        double my = this.imageView.getLayoutBounds().getHeight() - this.viewport.getHeight();
        x = Math.min(Math.max(0.0, x), mx);
        y = Math.min(Math.max(0.0, y), my);
        this.viewport.setX(x);
        this.viewport.setY(y);
    }

    private static final void _init_$lambda$4(ThumbnailListCell this$0, ObservableValue observableValue, PageKey pageKey, PageKey pageKey2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (pageKey2 == null) {
            this$0.renderService.setPage(-1);
        } else {
            this$0.renderService.setPage(pageKey2.getPageNumber());
            this$0.renderService.setRotation(pageKey2.getRotationAngle());
            if (pageKey2.getViewport() != null) {
                this$0.viewport.setWidth(pageKey2.getViewport().getWidth() * this$0.imageView.getLayoutBounds().getWidth());
                this$0.viewport.setHeight(pageKey2.getViewport().getHeight() * this$0.imageView.getLayoutBounds().getHeight());
                this$0.viewport.setX(pageKey2.getViewport().getMinX() * this$0.imageView.getLayoutBounds().getWidth());
                this$0.viewport.setY(pageKey2.getViewport().getMinY() * this$0.imageView.getLayoutBounds().getHeight());
                this$0.viewport.setVisible(true);
            } else {
                this$0.viewport.setVisible(false);
            }
        }
    }

    private static final void lambda$6$lambda$5(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void _init_$lambda$7(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    public static final /* synthetic */ void access$setDragstart$p(ThumbnailListCell $this, Point2D point2D) {
        $this.dragstart = point2D;
    }

    public static final /* synthetic */ Point2D access$getDragstart$p(ThumbnailListCell $this) {
        return $this.dragstart;
    }

    public static final /* synthetic */ void access$moveViewPort(ThumbnailListCell $this, Point2D offset) {
        $this.moveViewPort(offset);
    }

    public static final /* synthetic */ Rectangle access$getViewport$p(ThumbnailListCell $this) {
        return $this.viewport;
    }
}

