/*
 * Decompiled with CFR 0.152.
 */
package de.confinitum.pdfview.skin;

import de.confinitum.pdfview.PDFView;
import de.confinitum.pdfview.base.Document;
import de.confinitum.pdfview.base.PageKey;
import de.confinitum.pdfview.base.ToolbarConfig;
import de.confinitum.pdfview.base.UtilsKt;
import de.confinitum.pdfview.skin.MainScrollPane;
import de.confinitum.pdfview.skin.PostScroll;
import de.confinitum.pdfview.skin.ThumbnailListCell;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign2.MaterialDesignA;
import org.kordamp.ikonli.materialdesign2.MaterialDesignC;
import org.kordamp.ikonli.materialdesign2.MaterialDesignR;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0007J!\u0010\u001e\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0002\u0010\"J\u001a\u0010#\u001a\u00020\u00192\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/confinitum/pdfview/skin/PDFViewSkin;", "Ljavafx/scene/control/SkinBase;", "Lde/confinitum/pdfview/PDFView;", "view", "(Lde/confinitum/pdfview/PDFView;)V", "currentViewport", "Ljavafx/beans/property/ObjectProperty;", "Ljavafx/geometry/Rectangle2D;", "getCurrentViewport", "()Ljavafx/beans/property/ObjectProperty;", "mainArea", "Lde/confinitum/pdfview/skin/MainScrollPane;", "requestedVValue", "Lde/confinitum/pdfview/skin/PostScroll;", "getRequestedVValue", "()Lde/confinitum/pdfview/skin/PostScroll;", "setRequestedVValue", "(Lde/confinitum/pdfview/skin/PostScroll;)V", "resetThumbnailWidth", "", "thumbnailWidth", "Ljavafx/beans/property/DoubleProperty;", "createToolBar", "Ljavafx/scene/control/ToolBar;", "registerThumbnailWidth", "", "w", "", "setViewport", "rectangle", "switchViewport", "oldPage", "", "newPage", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "updateCurrentPageNumber", "pageField", "Ljavafx/scene/control/TextField;", "updateTotalPagesNumber", "totalPagesButton", "Ljavafx/scene/control/Button;", "kpdfx"})
@SourceDebugExtension(value={"SMAP\nPdfViewSkin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfViewSkin.kt\nde/confinitum/pdfview/skin/PDFViewSkin\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,337:1\n37#2,2:338\n*S KotlinDebug\n*F\n+ 1 PdfViewSkin.kt\nde/confinitum/pdfview/skin/PDFViewSkin\n*L\n315#1:338,2\n*E\n"})
public final class PDFViewSkin
extends SkinBase<PDFView> {
    @NotNull
    private final PDFView view;
    @NotNull
    private MainScrollPane mainArea;
    @NotNull
    private PostScroll requestedVValue;
    @NotNull
    private final DoubleProperty thumbnailWidth;
    private boolean resetThumbnailWidth;
    @NotNull
    private final ObjectProperty<Rectangle2D> currentViewport;

    public PDFViewSkin(@NotNull PDFView view) {
        BorderPane borderPane;
        String string;
        String observableList;
        ListView thumbnailListView;
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        super((Control)view);
        this.view = view;
        this.requestedVValue = PostScroll.NONE;
        this.thumbnailWidth = (DoubleProperty)new SimpleDoubleProperty(0.0);
        this.currentViewport = (ObjectProperty)new SimpleObjectProperty((Object)new Rectangle2D(0.0, 0.0, 1.0, 1.0));
        ListView $this$_init__u24lambda_u244 = thumbnailListView = new ListView();
        boolean bl = false;
        $this$_init__u24lambda_u244.getStyleClass().add((Object)"thumbnail-list-view");
        $this$_init__u24lambda_u244.setPlaceholder(null);
        $this$_init__u24lambda_u244.setCellFactory(arg_0 -> PDFViewSkin.lambda$4$lambda$0(this, arg_0));
        $this$_init__u24lambda_u244.prefWidthProperty().bind((ObservableValue)this.thumbnailWidth.add(40));
        $this$_init__u24lambda_u244.setMinWidth(Double.NEGATIVE_INFINITY);
        $this$_init__u24lambda_u244.getSelectionModel().selectedItemProperty().addListener((arg_0, arg_1, arg_2) -> PDFViewSkin.lambda$4$lambda$1((Function3)new Function3<ObservableValue<? extends PageKey>, PageKey, PageKey, Unit>(this){
            final /* synthetic */ PDFViewSkin this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(ObservableValue<? extends PageKey> observableValue, PageKey pageKey, PageKey s) {
                block0: {
                    PageKey pageKey2 = s;
                    if (pageKey2 == null) break block0;
                    PageKey pageKey3 = pageKey2;
                    PDFViewSkin pDFViewSkin = this.this$0;
                    PageKey it = pageKey3;
                    boolean bl = false;
                    PDFViewSkin.access$getView$p(pDFViewSkin).setPage(it.getPageNumber());
                }
            }
        }, arg_0, arg_1, arg_2));
        this.view.pageProperty().addListener(arg_0 -> PDFViewSkin.lambda$4$lambda$2($this$_init__u24lambda_u244, this, arg_0));
        $this$_init__u24lambda_u244.itemsProperty().addListener((arg_0, arg_1, arg_2) -> PDFViewSkin.lambda$4$lambda$3((Function3)new Function3<ObservableValue<? extends ObservableList<PageKey>>, ObservableList<PageKey>, ObservableList<PageKey>, Unit>((ListView<PageKey>)$this$_init__u24lambda_u244){
            final /* synthetic */ ListView<PageKey> $this_with;
            {
                this.$this_with = $receiver;
                super(3);
            }

            public final void invoke(ObservableValue<? extends ObservableList<PageKey>> observableValue, ObservableList<PageKey> observableList, ObservableList<PageKey> n) {
                block0: {
                    ObservableList<PageKey> observableList2 = n;
                    if (observableList2 == null) break block0;
                    ObservableList<PageKey> observableList3 = observableList2;
                    ListView<PageKey> listView = this.$this_with;
                    ObservableList<PageKey> it = observableList3;
                    boolean bl = false;
                    listView.getSelectionModel().select(0);
                }
            }
        }, arg_0, arg_1, arg_2));
        $this$_init__u24lambda_u244.requestFocus();
        ToolBar toolBar = this.createToolBar();
        HBox it = toolBar;
        boolean bl2 = false;
        ObservableList observableList2 = it.getStylesheets();
        URL uRL = PDFView.class.getResource("/pdf-view.css");
        String string2 = observableList = uRL != null ? uRL.toExternalForm() : null;
        if (string2 == null) {
            string = "";
        } else {
            Intrinsics.checkNotNull((Object)string2);
            string = observableList;
        }
        observableList2.add((Object)string);
        it.visibleProperty().bind((ObservableValue)this.view.showToolBarProperty());
        it.managedProperty().bind((ObservableValue)this.view.showToolBarProperty());
        ToolBar toolBar2 = toolBar;
        MainScrollPane mainScrollPane = new MainScrollPane(this);
        it = mainScrollPane;
        PDFViewSkin pDFViewSkin = this;
        boolean bl3 = false;
        VBox.setVgrow((Node)((Node)it), (Priority)Priority.ALWAYS);
        pDFViewSkin.mainArea = mainScrollPane;
        it = new HBox[]{this.mainArea};
        HBox it2 = it = new VBox((Node[])it);
        boolean bl4 = false;
        it2.setFillWidth(true);
        HBox hBox = it;
        it2 = new HBox[]{thumbnailListView};
        HBox it3 = it2 = new HBox((Node[])it2);
        boolean bl5 = false;
        it3.setFillHeight(true);
        it3.visibleProperty().bind((ObservableValue)this.view.showThumbnailsProperty());
        it3.managedProperty().bind((ObservableValue)this.view.showThumbnailsProperty());
        HBox leftSide = it2;
        BorderPane it4 = borderPane = new BorderPane();
        boolean bl6 = false;
        it4.setTop((Node)toolBar2);
        it4.setLeft((Node)leftSide);
        it4.setCenter((Node)hBox);
        it4.setFocusTraversable(false);
        BorderPane borderPane2 = borderPane;
        this.getChildren().add((Object)borderPane2);
        this.view.documentProperty().addListener((arg_0, arg_1, arg_2) -> PDFViewSkin._init_$lambda$10((Function3)new Function3<ObservableValue<? extends Document>, Document, Document, Unit>((ListView<PageKey>)thumbnailListView){
            final /* synthetic */ ListView<PageKey> $thumbnailListView;
            {
                this.$thumbnailListView = $thumbnailListView;
                super(3);
            }

            public final void invoke(ObservableValue<? extends Document> observableValue, @Nullable Document document, @Nullable Document n) {
                block0: {
                    Document document2 = n;
                    if (document2 == null) break block0;
                    Document document3 = document2;
                    PDFViewSkin pDFViewSkin = this;
                    ListView<PageKey> listView = this.$thumbnailListView;
                    Document it = document3;
                    boolean bl = false;
                    pDFViewSkin.resetThumbnailWidth = true;
                    listView.setItems(it.getPagesList());
                    listView.refresh();
                    pDFViewSkin.mainArea.reload();
                }
            }
        }, arg_0, arg_1, arg_2));
        if (thumbnailListView.getItems().isEmpty()) {
            Document document = this.view.getDocument();
            ObservableList<PageKey> it5 = document != null ? document.getPagesList() : null;
            boolean bl7 = false;
            thumbnailListView.setItems(it5);
        }
        this.view.pageProperty().addListener((arg_0, arg_1, arg_2) -> PDFViewSkin._init_$lambda$12((Function3)new Function3<ObservableValue<? extends Number>, Number, Number, Unit>(){

            public final void invoke(ObservableValue<? extends Number> observableValue, Number o, Number n) {
                this.switchViewport(o.intValue(), n.intValue());
            }
        }, arg_0, arg_1, arg_2));
        this.currentViewport.addListener((arg_0, arg_1, arg_2) -> PDFViewSkin._init_$lambda$13((Function3)new Function3<ObservableValue<? extends Rectangle2D>, Rectangle2D, Rectangle2D, Unit>(){

            public final void invoke(ObservableValue<? extends Rectangle2D> observableValue, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
                this.switchViewport(null, view.getPage());
            }
        }, arg_0, arg_1, arg_2));
    }

    @NotNull
    public final PostScroll getRequestedVValue() {
        return this.requestedVValue;
    }

    public final void setRequestedVValue(@NotNull PostScroll postScroll) {
        Intrinsics.checkNotNullParameter((Object)((Object)postScroll), (String)"<set-?>");
        this.requestedVValue = postScroll;
    }

    @NotNull
    public final ObjectProperty<Rectangle2D> getCurrentViewport() {
        return this.currentViewport;
    }

    public final void setViewport(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.mainArea.setViewport(rectangle);
    }

    public final void registerThumbnailWidth(double w) {
        if (this.resetThumbnailWidth) {
            double diff = this.thumbnailWidth.get() - w;
            if (diff > 4.0 || diff < 0.0) {
                this.thumbnailWidth.set(w + (double)2);
            }
            this.resetThumbnailWidth = false;
        } else {
            this.thumbnailWidth.set(Math.max(this.thumbnailWidth.get(), w));
        }
    }

    private final void switchViewport(Integer oldPage, Integer newPage) {
        block2: {
            int it;
            block3: {
                Integer n = oldPage;
                if (n != null) {
                    it = ((Number)n).intValue();
                    boolean bl = false;
                    Document document = this.view.getDocument();
                    if (document != null) {
                        document.setViewport(it, null);
                    }
                }
                Integer n2 = newPage;
                if (n2 == null) break block2;
                it = ((Number)n2).intValue();
                boolean bl = false;
                Rectangle2D vp = (Rectangle2D)this.currentViewport.get();
                Rectangle2D vpn = new Rectangle2D(Math.max(vp.getMinX(), 0.0), Math.max(vp.getMinY(), 0.0), Math.min(vp.getWidth(), 1.0), Math.min(vp.getHeight(), 1.0));
                if (Intrinsics.areEqual((Object)vpn, (Object)new Rectangle2D(0.0, 0.0, 1.0, 1.0))) break block3;
                Document document = this.view.getDocument();
                if (document == null) break block2;
                document.setViewport(it, vpn);
                break block2;
            }
            Document document = this.view.getDocument();
            if (document == null) break block2;
            document.setViewport(it, null);
        }
    }

    private final ToolBar createToolBar() {
        Object[] it;
        Button goRight;
        Node[] zoomLabel;
        Observable[] valueListener;
        Object[] objectArray;
        Object[] objectArray2;
        ToggleButton it2;
        ToggleButton toggleButton;
        PDFView view;
        PDFView pDFView = view = (PDFView)this.getSkinnable();
        Intrinsics.checkNotNull((Object)((Object)pDFView));
        ToolbarConfig config = pDFView.getToolbarConfig();
        List nodes = new ArrayList();
        if (config.getThumbnails()) {
            it2 = toggleButton = new ToggleButton();
            boolean bl = false;
            it2.setGraphic((Node)new FontIcon((Ikon)MaterialDesignA.ANIMATION_OUTLINE));
            objectArray2 = new String[]{"tool-bar-button", "show-thumbnails-button"};
            it2.getStyleClass().addAll(objectArray2);
            it2.setTooltip(new Tooltip("show/hide thumbnails"));
            it2.selectedProperty().bindBidirectional((Property)view.showThumbnailsProperty());
            ToggleButton showThumbnails = toggleButton;
            nodes.add(showThumbnails);
            nodes.add(new Separator(Orientation.VERTICAL));
        }
        if (config.getPageFit()) {
            it2 = toggleButton = new ToggleButton();
            boolean bl = false;
            it2.setGraphic((Node)new FontIcon((Ikon)MaterialDesignA.ARROW_EXPAND_VERTICAL));
            objectArray2 = new String[]{"tool-bar-button", "show-all-button"};
            it2.getStyleClass().addAll(objectArray2);
            it2.setTooltip(new Tooltip("Show all / whole page"));
            view.fitVerticalProperty().bindBidirectional((Property)it2.selectedProperty());
            ToggleButton showVertical = toggleButton;
            ToggleButton it3 = it2 = new ToggleButton();
            boolean bl2 = false;
            it3.setGraphic((Node)new FontIcon((Ikon)MaterialDesignA.ARROW_EXPAND_HORIZONTAL));
            objectArray = new String[]{"tool-bar-button", "show-all-button"};
            it3.getStyleClass().addAll(objectArray);
            it3.setTooltip(new Tooltip("fit horizontally"));
            view.fitHorizontalProperty().bindBidirectional((Property)it3.selectedProperty());
            ToggleButton showHorizontal = it2;
            nodes.add(showVertical);
            nodes.add(showHorizontal);
            nodes.add(new Separator(Orientation.VERTICAL));
        }
        if (config.getZooming()) {
            Slider zoomSlider;
            Slider $this$createToolBar_u24lambda_u2422 = zoomSlider = new Slider();
            boolean bl = false;
            $this$createToolBar_u24lambda_u2422.minProperty().set(0.0);
            $this$createToolBar_u24lambda_u2422.maxProperty().bind((ObservableValue)view.maxZoomFactorProperty());
            $this$createToolBar_u24lambda_u2422.setValue(view.getZoomFactor());
            $this$createToolBar_u24lambda_u2422.setShowTickMarks(true);
            $this$createToolBar_u24lambda_u2422.setMajorTickUnit(0.5);
            $this$createToolBar_u24lambda_u2422.setShowTickLabels(true);
            Ref.ObjectRef zoomListener = new Ref.ObjectRef();
            zoomListener.element = PDFViewSkin::createToolBar$lambda$22$lambda$19;
            valueListener = (arg_0, arg_1, arg_2) -> PDFViewSkin.createToolBar$lambda$22$lambda$20(view, zoomListener, arg_0, arg_1, arg_2);
            zoomListener.element = (arg_0, arg_1, arg_2) -> PDFViewSkin.createToolBar$lambda$22$lambda$21($this$createToolBar_u24lambda_u2422, (ChangeListener)valueListener, arg_0, arg_1, arg_2);
            $this$createToolBar_u24lambda_u2422.valueProperty().addListener((ChangeListener)valueListener);
            view.zoomFactorProperty().addListener((ChangeListener)zoomListener.element);
            zoomLabel = new Label("Zoom");
            nodes.add(zoomLabel);
            nodes.add(zoomSlider);
            nodes.add(new Separator(Orientation.VERTICAL));
        }
        if (config.getPages()) {
            Node[] it4 = zoomLabel = new Button();
            boolean bl = false;
            it4.setGraphic((Node)new FontIcon((Ikon)MaterialDesignC.CHEVRON_LEFT));
            it4.setTooltip(new Tooltip("Show previous page"));
            it4.setOnAction(arg_0 -> PDFViewSkin.createToolBar$lambda$25$lambda$23(view, arg_0));
            valueListener = new Observable[]{"tool-bar-button", "previous-page-button"};
            it4.getStyleClass().addAll((Object[])valueListener);
            valueListener = new Observable[]{view.pageProperty(), view.documentProperty()};
            it4.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> PDFViewSkin.createToolBar$lambda$25$lambda$24(view), (Observable[])valueListener));
            Node[] goLeft = zoomLabel;
            Node[] it5 = it4 = new Button();
            boolean bl3 = false;
            it5.setGraphic((Node)new FontIcon((Ikon)MaterialDesignC.CHEVRON_RIGHT));
            it5.setTooltip(new Tooltip("Show next page"));
            it5.setOnAction(arg_0 -> PDFViewSkin.createToolBar$lambda$28$lambda$26(view, arg_0));
            objectArray = new String[]{"tool-bar-button", "next-page-button"};
            it5.getStyleClass().addAll(objectArray);
            objectArray = new Observable[]{view.pageProperty(), view.documentProperty()};
            it5.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> PDFViewSkin.createToolBar$lambda$28$lambda$27(view), (Observable[])objectArray));
            goRight = it4;
            it = it5 = new TextField();
            boolean bl4 = false;
            it.setTooltip(new Tooltip("Current page number"));
            it.getStyleClass().add((Object)"page-field");
            it.maxHeightProperty().bind((ObservableValue)goLeft.heightProperty());
            it.setAlignment(Pos.CENTER);
            this.updateCurrentPageNumber(view, (TextField)it);
            Node[] pageField = it5;
            view.pageProperty().addListener(arg_0 -> PDFViewSkin.createToolBar$lambda$30(this, view, (TextField)pageField, arg_0));
            pageField.textProperty().addListener((arg_0, arg_1, arg_2) -> PDFViewSkin.createToolBar$lambda$31((Function3)new Function3<ObservableValue<? extends String>, String, String, Unit>(view){
                final /* synthetic */ PDFView $view;
                {
                    this.$view = $view;
                    super(3);
                }

                public final void invoke(ObservableValue<? extends String> observableValue, String string, String n) {
                    try {
                        String string2 = n;
                        if (string2 != null) {
                            String string3 = string2;
                            PDFView pDFView = this.$view;
                            String it = string3;
                            boolean bl = false;
                            pDFView.setPage(Integer.parseInt(it) - 1);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }, arg_0, arg_1, arg_2));
            Node[] it6 = it = new Button();
            boolean bl5 = false;
            it6.setTooltip(new Tooltip("Total number of pages"));
            it6.getStyleClass().add((Object)"page-number-button");
            it6.maxHeightProperty().bind((ObservableValue)goLeft.heightProperty());
            it6.setAlignment(Pos.CENTER);
            it6.setOnAction(arg_0 -> PDFViewSkin.createToolBar$lambda$33$lambda$32(view, arg_0));
            it6.setFocusTraversable(false);
            this.updateTotalPagesNumber((Button)it6);
            Node[] totalPages = it;
            view.documentProperty().addListener((arg_0, arg_1, arg_2) -> PDFViewSkin.createToolBar$lambda$34((Function3)new Function3<ObservableValue<? extends Document>, Document, Document, Unit>(this, (Button)totalPages){
                final /* synthetic */ PDFViewSkin this$0;
                final /* synthetic */ Button $totalPages;
                {
                    this.this$0 = $receiver;
                    this.$totalPages = $totalPages;
                    super(3);
                }

                public final void invoke(ObservableValue<? extends Document> observableValue, @Nullable Document document, @Nullable Document document2) {
                    PDFViewSkin.access$updateTotalPagesNumber(this.this$0, this.$totalPages);
                }
            }, arg_0, arg_1, arg_2));
            it = new Node[]{goLeft, pageField, totalPages, goRight};
            HBox $this$createToolBar_u24lambda_u2435 = new HBox(it);
            boolean bl6 = false;
            $this$createToolBar_u24lambda_u2435.setFillHeight(true);
            $this$createToolBar_u24lambda_u2435.disableProperty().bind((ObservableValue)view.documentProperty().isNull());
            $this$createToolBar_u24lambda_u2435.getStyleClass().add((Object)"page-control");
            $this$createToolBar_u24lambda_u2435.setAlignment(Pos.CENTER_LEFT);
            nodes.add($this$createToolBar_u24lambda_u2435);
            nodes.add(new Separator(Orientation.VERTICAL));
        }
        if (config.getRotation()) {
            Button it7 = goRight = new Button();
            boolean bl = false;
            it = new String[]{"tool-bar-button", "rotate-left"};
            it7.getStyleClass().addAll(it);
            it7.setTooltip(new Tooltip("Rotate page left"));
            it7.setGraphic((Node)new FontIcon((Ikon)MaterialDesignR.ROTATE_LEFT));
            it7.setOnAction(arg_0 -> PDFViewSkin.createToolBar$lambda$37$lambda$36(view, arg_0));
            Button rotateLeft = goRight;
            Button it8 = it7 = new Button();
            boolean bl7 = false;
            objectArray = new String[]{"tool-bar-button", "rotate-right"};
            it8.getStyleClass().addAll(objectArray);
            it8.setTooltip(new Tooltip("Rotate page right"));
            it8.setGraphic((Node)new FontIcon((Ikon)MaterialDesignR.ROTATE_RIGHT));
            it8.setOnAction(arg_0 -> PDFViewSkin.createToolBar$lambda$39$lambda$38(view, arg_0));
            Button rotateRight = it7;
            nodes.add(rotateLeft);
            nodes.add(rotateRight);
        }
        Collection $this$toTypedArray$iv = nodes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Node[] nodeArray = thisCollection$iv.toArray(new Node[0]);
        return new ToolBar(Arrays.copyOf(nodeArray, nodeArray.length));
    }

    private final void updateCurrentPageNumber(PDFView view, TextField pageField) {
        Function0<Unit> function0;
        Object object = view;
        if (object != null && (object = object.getDocument()) != null) {
            Object it = object;
            boolean bl = false;
            pageField.setText(String.valueOf(view.getPage() + 1));
            function0 = Unit.INSTANCE;
        } else {
            function0 = new Function0<Unit>(pageField){
                final /* synthetic */ TextField $pageField;
                {
                    this.$pageField = $pageField;
                    super(0);
                }

                public final void invoke() {
                    this.$pageField.setText("0");
                }
            };
        }
    }

    private final void updateTotalPagesNumber(Button totalPagesButton) {
        Function0<Unit> function0;
        Object object = (PDFView)this.getSkinnable();
        if (object != null && (object = object.getDocument()) != null) {
            PDFView it = object;
            boolean bl = false;
            totalPagesButton.setText("/ " + it.getNumberOfPages());
            function0 = Unit.INSTANCE;
        } else {
            function0 = new Function0<Unit>(totalPagesButton){
                final /* synthetic */ Button $totalPagesButton;
                {
                    this.$totalPagesButton = $totalPagesButton;
                    super(0);
                }

                public final void invoke() {
                    this.$totalPagesButton.setText("/ 0");
                }
            };
        }
    }

    private static final ListCell lambda$4$lambda$0(PDFViewSkin this$0, ListView listView) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return new ThumbnailListCell(this$0);
    }

    private static final void lambda$4$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void lambda$4$lambda$2(ListView $this_with, PDFViewSkin this$0, Observable observable) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        $this_with.getSelectionModel().select(this$0.view.getPage());
        Object object = $this_with.getSelectionModel().getSelectedItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSelectedItem(...)");
        UtilsKt.maybeScrollTo($this_with, object);
    }

    private static final void lambda$4$lambda$3(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void _init_$lambda$10(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void _init_$lambda$12(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void _init_$lambda$13(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void createToolBar$lambda$22$lambda$19(ObservableValue observableValue, Number number, Number number2) {
    }

    private static final void createToolBar$lambda$22$lambda$20(PDFView $view, Ref.ObjectRef $zoomListener, ObservableValue observableValue, Number number, Number newValue) {
        Intrinsics.checkNotNullParameter((Object)$zoomListener, (String)"$zoomListener");
        $view.zoomFactorProperty().removeListener((ChangeListener)$zoomListener.element);
        $view.setFitHorizontal(false);
        $view.setFitVertical(false);
        $view.setZoomFactor(newValue.doubleValue());
        $view.zoomFactorProperty().addListener((ChangeListener)$zoomListener.element);
    }

    private static final void createToolBar$lambda$22$lambda$21(Slider $this_with, ChangeListener $valueListener, ObservableValue observableValue, Number number, Number n) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        Intrinsics.checkNotNullParameter((Object)$valueListener, (String)"$valueListener");
        $this_with.valueProperty().removeListener($valueListener);
        $this_with.setValue(n.doubleValue());
        $this_with.valueProperty().addListener($valueListener);
    }

    private static final void createToolBar$lambda$25$lambda$23(PDFView $view, ActionEvent actionEvent) {
        $view.gotoPreviousPage();
    }

    private static final Boolean createToolBar$lambda$25$lambda$24(PDFView $view) {
        return $view.getPage() <= 0;
    }

    private static final void createToolBar$lambda$28$lambda$26(PDFView $view, ActionEvent actionEvent) {
        $view.gotoNextPage();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Boolean createToolBar$lambda$28$lambda$27(PDFView $view) {
        boolean bl;
        if ($view.getDocument() != null) {
            Document document = $view.getDocument();
            Intrinsics.checkNotNull((Object)document);
            if (document.getNumberOfPages() > $view.getPage() + 1) {
                bl = false;
                return bl;
            }
        }
        bl = true;
        return bl;
    }

    private static final void createToolBar$lambda$30(PDFViewSkin this$0, PDFView $view, TextField $pageField, Observable observable) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pageField, (String)"$pageField");
        this$0.updateCurrentPageNumber($view, $pageField);
    }

    private static final void createToolBar$lambda$31(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void createToolBar$lambda$33$lambda$32(PDFView $view, ActionEvent actionEvent) {
        $view.gotoLastPage();
    }

    private static final void createToolBar$lambda$34(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void createToolBar$lambda$37$lambda$36(PDFView $view, ActionEvent actionEvent) {
        $view.rotateLeft();
    }

    private static final void createToolBar$lambda$39$lambda$38(PDFView $view, ActionEvent actionEvent) {
        $view.rotateRight();
    }

    public static final /* synthetic */ void access$updateTotalPagesNumber(PDFViewSkin $this, Button totalPagesButton) {
        $this.updateTotalPagesNumber(totalPagesButton);
    }
}

