/*
 * Decompiled with CFR 0.152.
 */
package de.confinitum.pdfview.skin;

import de.confinitum.pdfview.PDFView;
import de.confinitum.pdfview.base.RenderService;
import de.confinitum.pdfview.skin.PDFViewSkin;
import de.confinitum.pdfview.skin.PostScroll;
import java.net.URL;
import javafx.animation.RotateTransition;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\u001a\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\u0016H\u0002J\u0006\u0010#\u001a\u00020\u0018J\u000e\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J \u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lde/confinitum/pdfview/skin/MainScrollPane;", "Ljavafx/scene/control/ScrollPane;", "pdfViewSkin", "Lde/confinitum/pdfview/skin/PDFViewSkin;", "(Lde/confinitum/pdfview/skin/PDFViewSkin;)V", "imageScale", "Ljavafx/beans/property/SimpleDoubleProperty;", "imageView", "Ljavafx/scene/image/ImageView;", "isNotZoomable", "", "()Z", "keyScroll", "", "mainAreaRenderService", "Lde/confinitum/pdfview/base/RenderService;", "pane", "Ljavafx/scene/layout/Pane;", "screenScale", "waitImage", "zoomLock", "zoomMousePointer", "Ljavafx/geometry/Point2D;", "calculateViewport", "", "fitHeight", "fitWidth", "fitWidthOrHeight", "getViewportOffset", "getViewportScroll", "offset", "layoutImage", "image", "Ljavafx/scene/image/Image;", "scrollValue", "reload", "setViewport", "vp", "Ljavafx/geometry/Rectangle2D;", "zoom", "oldZoom", "newZoom", "mousePointer", "Companion", "kpdfx"})
public final class MainScrollPane
extends ScrollPane {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PDFViewSkin pdfViewSkin;
    @NotNull
    private final RenderService mainAreaRenderService;
    @NotNull
    private final ImageView imageView;
    @NotNull
    private final ImageView waitImage;
    @NotNull
    private final Pane pane;
    private final double screenScale;
    @NotNull
    private final SimpleDoubleProperty imageScale;
    private final double keyScroll;
    @Nullable
    private Point2D zoomMousePointer;
    private boolean zoomLock;
    private static final double ZOOM_DELTA = 0.1;

    public MainScrollPane(@NotNull PDFViewSkin pdfViewSkin) {
        RotateTransition rotateTransition;
        Node[] it;
        Intrinsics.checkNotNullParameter((Object)((Object)pdfViewSkin), (String)"pdfViewSkin");
        this.pdfViewSkin = pdfViewSkin;
        this.mainAreaRenderService = new RenderService(this.pdfViewSkin, false, null, 4, null);
        this.imageScale = new SimpleDoubleProperty(1.0);
        final PDFView pdfView = (PDFView)this.pdfViewSkin.getSkinnable();
        this.setPannable(true);
        double screenDpi = Screen.getPrimary().getDpi();
        this.screenScale = screenDpi / 72.0;
        this.imageScale.bind((ObservableValue)pdfView.pageRenderDpiProperty().divide(72.0));
        this.keyScroll = 0.5 * screenDpi;
        Object[] objectArray = new ImageView();
        Node[] nodeArray = objectArray;
        MainScrollPane mainScrollPane = this;
        boolean bl = false;
        it.setPreserveRatio(true);
        it.setCache(false);
        it.imageProperty().addListener((arg_0, arg_1, arg_2) -> MainScrollPane.lambda$1$lambda$0((Function3)new Function3<ObservableValue<? extends Image>, Image, Image, Unit>(this){
            final /* synthetic */ MainScrollPane this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(ObservableValue<? extends Image> observableValue, Image image, Image n) {
                block0: {
                    Image image2 = n;
                    if (image2 == null) break block0;
                    Image image3 = image2;
                    MainScrollPane mainScrollPane = this.this$0;
                    Image image4 = image3;
                    boolean bl = false;
                    MainScrollPane.layoutImage$default(mainScrollPane, image4, null, 2, null);
                }
            }
        }, arg_0, arg_1, arg_2));
        mainScrollPane.imageView = objectArray;
        objectArray = new ImageView();
        it = objectArray;
        mainScrollPane = this;
        boolean bl2 = false;
        URL uRL = ((Object)((Object)this)).getClass().getResource("/wait12t.gif");
        it.setImage(new Image(uRL != null ? uRL.toExternalForm() : null));
        it.setPreserveRatio(true);
        it.setManaged(false);
        it.setVisible(false);
        mainScrollPane.waitImage = objectArray;
        RenderService $this$_init__u24lambda_u247 = this.mainAreaRenderService;
        boolean bl3 = false;
        $this$_init__u24lambda_u247.scaleProperty().bind((ObservableValue)this.imageScale);
        $this$_init__u24lambda_u247.pageProperty().bind((ObservableValue)pdfView.pageProperty());
        $this$_init__u24lambda_u247.rotationProperty().bind((ObservableValue)pdfView.pageRotationProperty());
        $this$_init__u24lambda_u247.valueProperty().addListener((arg_0, arg_1, arg_2) -> MainScrollPane.lambda$7$lambda$3((Function3)new Function3<ObservableValue<? extends Image>, Image, Image, Unit>(this){
            final /* synthetic */ MainScrollPane this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(ObservableValue<? extends Image> observableValue, Image image, Image n) {
                block0: {
                    Image image2 = n;
                    if (image2 == null) break block0;
                    Image image3 = image2;
                    MainScrollPane mainScrollPane = this.this$0;
                    Image image4 = image3;
                    boolean bl = false;
                    MainScrollPane.access$getImageView$p(mainScrollPane).setImage(image4);
                }
            }
        }, arg_0, arg_1, arg_2));
        RotateTransition it2 = rotateTransition = new RotateTransition(Duration.millis((double)1800.0), (Node)this.waitImage);
        boolean bl4 = false;
        it2.setByAngle(360.0);
        it2.setCycleCount(12);
        it2.setAutoReverse(false);
        RotateTransition wait = rotateTransition;
        $this$_init__u24lambda_u247.setOnScheduled(arg_0 -> MainScrollPane.lambda$7$lambda$5(this, wait, arg_0));
        $this$_init__u24lambda_u247.setOnSucceeded(arg_0 -> MainScrollPane.lambda$7$lambda$6($this$_init__u24lambda_u247, this, wait, arg_0));
        objectArray = new Node[]{this.imageView, this.waitImage};
        this.pane = new Pane((Node[])objectArray);
        objectArray = new String[]{"image-view-wrapper"};
        this.pane.getStyleClass().addAll(objectArray);
        this.setContent((Node)this.pane);
        pdfView.fitVerticalProperty().addListener((arg_0, arg_1, arg_2) -> MainScrollPane._init_$lambda$8((Function3)new Function3<ObservableValue<? extends Boolean>, Boolean, Boolean, Unit>(){

            public final void invoke(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean n) {
                Intrinsics.checkNotNull((Object)n);
                if (n.booleanValue()) {
                    pdfView.setFitHorizontal(false);
                    this.fitHeight();
                }
            }
        }, arg_0, arg_1, arg_2));
        pdfView.fitHorizontalProperty().addListener((arg_0, arg_1, arg_2) -> MainScrollPane._init_$lambda$9((Function3)new Function3<ObservableValue<? extends Boolean>, Boolean, Boolean, Unit>(){

            public final void invoke(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean n) {
                Intrinsics.checkNotNull((Object)n);
                if (n.booleanValue()) {
                    pdfView.setFitVertical(false);
                    this.fitWidth();
                }
            }
        }, arg_0, arg_1, arg_2));
        pdfView.zoomFactorProperty().addListener((arg_0, arg_1, arg_2) -> MainScrollPane._init_$lambda$10((Function3)new Function3<ObservableValue<? extends Number>, Number, Number, Unit>(){

            public final void invoke(ObservableValue<? extends Number> observableValue, Number o, Number n) {
                Point2D point2D = zoomMousePointer;
                if (point2D == null) {
                    point2D = new Point2D(this.getWidth() / (double)2, this.getHeight() / (double)2);
                }
                Point2D mousePointer = point2D;
                this.zoom(o.doubleValue(), n.doubleValue(), mousePointer);
            }
        }, arg_0, arg_1, arg_2));
        this.getContent().setOnScroll(new EventHandler(){

            public final void handle(ScrollEvent it) {
                if (it.isInertia()) {
                    return;
                }
                if (it.isShortcutDown()) {
                    if (this.isNotZoomable()) {
                        pdfView.setFitVertical(false);
                        pdfView.setFitHorizontal(false);
                    }
                    double delta = it.getDeltaY() > 0.0 ? 0.1 : -0.1;
                    zoomMousePointer = this.sceneToLocal(new Point2D(it.getSceneX(), it.getSceneY()));
                    double old = pdfView.getZoomFactor();
                    pdfView.setZoomFactor(old + delta);
                    it.consume();
                } else {
                    double deltaY = it.getDeltaY() * (double)6;
                    MainScrollPane mainScrollPane = this;
                    mainScrollPane.setVvalue(mainScrollPane.getVvalue() - deltaY / this.getContent().getLayoutBounds().getHeight());
                    it.consume();
                }
            }
        });
        this.setOnKeyPressed(new EventHandler(){

            public final void handle(@NotNull KeyEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                KeyCode keyCode = evt.getCode();
                switch (keyCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[keyCode.ordinal()]) {
                    case 1: {
                        if (this.getVvalue() > 0.0) {
                            MainScrollPane mainScrollPane = this;
                            mainScrollPane.setVvalue(mainScrollPane.getVvalue() - this.getHeight());
                            break;
                        }
                        pdfViewSkin.setRequestedVValue(PostScroll.UP);
                        pdfView.gotoPreviousPage();
                        break;
                    }
                    case 2: {
                        if (this.getVvalue() < this.getVmax()) {
                            MainScrollPane mainScrollPane = this;
                            mainScrollPane.setVvalue(mainScrollPane.getVvalue() + this.getHeight());
                            break;
                        }
                        pdfViewSkin.setRequestedVValue(PostScroll.DOWN);
                        pdfView.gotoNextPage();
                        break;
                    }
                    case 3: {
                        this.setVvalue(0.0);
                        break;
                    }
                    case 4: {
                        this.setVvalue(this.getVmax());
                        break;
                    }
                    case 5: {
                        if (!(this.getHvalue() > 0.0)) break;
                        MainScrollPane mainScrollPane = this;
                        mainScrollPane.setHvalue(mainScrollPane.getHvalue() - keyScroll);
                        break;
                    }
                    case 6: {
                        if (!(this.getHvalue() < this.getHmax())) break;
                        MainScrollPane mainScrollPane = this;
                        mainScrollPane.setHvalue(mainScrollPane.getHvalue() + keyScroll);
                        break;
                    }
                    case 7: {
                        if (!(this.getVvalue() < this.getVmax())) break;
                        MainScrollPane mainScrollPane = this;
                        mainScrollPane.setVvalue(mainScrollPane.getVvalue() + keyScroll);
                        break;
                    }
                    case 8: {
                        if (!(this.getVvalue() > 0.0)) break;
                        MainScrollPane mainScrollPane = this;
                        mainScrollPane.setVvalue(mainScrollPane.getVvalue() - keyScroll);
                        break;
                    }
                }
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[KeyCode.values().length];
                    try {
                        nArray[KeyCode.PAGE_UP.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[KeyCode.PAGE_DOWN.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[KeyCode.HOME.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[KeyCode.END.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[KeyCode.LEFT.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[KeyCode.RIGHT.ordinal()] = 6;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[KeyCode.DOWN.ordinal()] = 7;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[KeyCode.UP.ordinal()] = 8;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
        this.viewportBoundsProperty().addListener((arg_0, arg_1, arg_2) -> MainScrollPane._init_$lambda$11((Function3)new Function3<ObservableValue<? extends Bounds>, Bounds, Bounds, Unit>(){

            public final void invoke(ObservableValue<? extends Bounds> observableValue, Bounds bounds, Bounds bounds2) {
                this.fitWidthOrHeight();
                this.calculateViewport();
            }
        }, arg_0, arg_1, arg_2));
        this.vvalueProperty().addListener((arg_0, arg_1, arg_2) -> MainScrollPane._init_$lambda$12((Function3)new Function3<ObservableValue<? extends Number>, Number, Number, Unit>(){

            public final void invoke(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                this.calculateViewport();
            }
        }, arg_0, arg_1, arg_2));
        this.hvalueProperty().addListener((arg_0, arg_1, arg_2) -> MainScrollPane._init_$lambda$13((Function3)new Function3<ObservableValue<? extends Number>, Number, Number, Unit>(){

            public final void invoke(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                this.calculateViewport();
            }
        }, arg_0, arg_1, arg_2));
    }

    public final void reload() {
        this.mainAreaRenderService.restart();
    }

    private final void zoom(double oldZoom, double newZoom, Point2D mousePointer) {
        block0: {
            Point2D mouseOffset = this.getViewportOffset().add(mousePointer);
            Point2D imageOffset = mouseOffset.multiply(1.0 / oldZoom);
            Point2D newMouseOffset = imageOffset.multiply(newZoom);
            Point2D offset = newMouseOffset.subtract(mousePointer);
            Intrinsics.checkNotNull((Object)offset);
            Point2D scrollValue = this.getViewportScroll(offset);
            Image image = this.imageView.getImage();
            if (image == null) break block0;
            Image it = image;
            boolean bl = false;
            this.layoutImage(it, scrollValue);
        }
    }

    private final void layoutImage(Image image, Point2D scrollValue) {
        ImageView it = this.imageView;
        boolean bl = false;
        it.setFitWidth(image.getWidth() / this.imageScale.get() * this.screenScale * ((PDFView)this.pdfViewSkin.getSkinnable()).getZoomFactor());
        it.setFitHeight(image.getHeight() / this.imageScale.get() * this.screenScale * ((PDFView)this.pdfViewSkin.getSkinnable()).getZoomFactor());
        this.setHvalue(scrollValue.getX());
        this.setVvalue(scrollValue.getY());
        this.fitWidthOrHeight();
    }

    static /* synthetic */ void layoutImage$default(MainScrollPane mainScrollPane, Image image, Point2D point2D, int n, Object object) {
        if ((n & 2) != 0) {
            point2D = new Point2D(mainScrollPane.getHvalue(), mainScrollPane.getVvalue());
        }
        mainScrollPane.layoutImage(image, point2D);
    }

    private final void fitWidthOrHeight() {
        if (((PDFView)this.pdfViewSkin.getSkinnable()).isFitVertical()) {
            this.fitHeight();
        }
        if (((PDFView)this.pdfViewSkin.getSkinnable()).isFitHorizontal()) {
            this.fitWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fitWidth() {
        if (this.zoomLock) {
            return;
        }
        this.zoomLock = true;
        try {
            double width = this.imageView.getFitWidth() / ((PDFView)this.pdfViewSkin.getSkinnable()).getZoomFactor() + (double)10;
            double zoom = this.getWidth() / width;
            ((PDFView)this.pdfViewSkin.getSkinnable()).setZoomFactor(zoom);
        }
        finally {
            this.zoomLock = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fitHeight() {
        if (this.zoomLock) {
            return;
        }
        this.zoomLock = true;
        try {
            double height = this.imageView.getFitHeight() / ((PDFView)this.pdfViewSkin.getSkinnable()).getZoomFactor() + (double)10;
            double zoom = this.getHeight() / height;
            ((PDFView)this.pdfViewSkin.getSkinnable()).setZoomFactor(zoom);
        }
        finally {
            this.zoomLock = false;
        }
    }

    private final boolean isNotZoomable() {
        return ((PDFView)this.pdfViewSkin.getSkinnable()).isFitHorizontal() || ((PDFView)this.pdfViewSkin.getSkinnable()).isFitVertical();
    }

    private final Point2D getViewportOffset() {
        double offContentWidth = Math.max(0.0, this.getContent().getLayoutBounds().getWidth() - this.getViewportBounds().getWidth());
        double offContentHeight = Math.max(0.0, this.getContent().getLayoutBounds().getHeight() - this.getViewportBounds().getHeight());
        return new Point2D(offContentWidth * this.getHvalue(), offContentHeight * this.getVvalue());
    }

    private final Point2D getViewportScroll(Point2D offset) {
        double offContentWidth = Math.max(0.0, this.getContent().getLayoutBounds().getWidth() - this.getViewportBounds().getWidth());
        double offContentHeight = Math.max(0.0, this.getContent().getLayoutBounds().getHeight() - this.getViewportBounds().getHeight());
        return new Point2D(offContentWidth == 0.0 ? 0.0 : offset.getX() / offContentWidth, offContentHeight == 0.0 ? 0.0 : offset.getY() / offContentHeight);
    }

    private final void calculateViewport() {
        Point2D offset = this.getViewportOffset();
        this.pdfViewSkin.getCurrentViewport().set((Object)new Rectangle2D(offset.getX() / this.imageView.getFitWidth(), offset.getY() / this.imageView.getFitHeight(), this.getViewportBounds().getWidth() / this.imageView.getFitWidth(), this.getViewportBounds().getHeight() / this.imageView.getFitHeight()));
    }

    public final void setViewport(@NotNull Rectangle2D vp) {
        Intrinsics.checkNotNullParameter((Object)vp, (String)"vp");
        Point2D offset = new Point2D(vp.getMinX() * this.imageView.getFitWidth(), vp.getMinY() * this.imageView.getFitHeight());
        Point2D scroll = this.getViewportScroll(offset);
        this.setHvalue(scroll.getX());
        this.setVvalue(scroll.getY());
    }

    private static final void lambda$1$lambda$0(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void lambda$7$lambda$3(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void lambda$7$lambda$5(MainScrollPane this$0, RotateTransition $wait, WorkerStateEvent workerStateEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$wait, (String)"$wait");
        Point2D mid = new Point2D(this$0.getViewportBounds().getWidth() / (double)2 - (double)30, this$0.getViewportBounds().getHeight() / (double)2 - (double)30);
        Point2D offset = this$0.getViewportOffset().add(mid);
        this$0.waitImage.relocate(offset.getX(), offset.getY());
        this$0.waitImage.setVisible(true);
        this$0.imageView.setOpacity(0.3);
        $wait.play();
    }

    private static final void lambda$7$lambda$6(RenderService $this_with, MainScrollPane this$0, RotateTransition $wait, WorkerStateEvent workerStateEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_with), (String)"$this_with");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$wait, (String)"$wait");
        switch (WhenMappings.$EnumSwitchMapping$0[$this_with.getPdfViewSkin().getRequestedVValue().ordinal()]) {
            case 1: {
                this$0.setVvalue(1.0);
                break;
            }
            case 2: {
                this$0.setVvalue(0.0);
            }
        }
        $this_with.getPdfViewSkin().setRequestedVValue(PostScroll.NONE);
        $wait.stop();
        this$0.waitImage.setVisible(false);
        this$0.imageView.setOpacity(1.0);
    }

    private static final void _init_$lambda$8(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void _init_$lambda$9(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void _init_$lambda$10(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void _init_$lambda$11(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void _init_$lambda$12(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void _init_$lambda$13(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    public static final /* synthetic */ ImageView access$getImageView$p(MainScrollPane $this) {
        return $this.imageView;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lde/confinitum/pdfview/skin/MainScrollPane$Companion;", "", "()V", "ZOOM_DELTA", "", "kpdfx"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PostScroll.values().length];
            try {
                nArray[PostScroll.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PostScroll.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

