/*
 * Decompiled with CFR 0.152.
 */
package de.confinitum.pdfview.base;

import de.confinitum.pdfview.PDFView;
import de.confinitum.pdfview.base.RenderTask;
import de.confinitum.pdfview.skin.PDFViewSkin;
import java.util.concurrent.Executor;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.image.Image;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020&H\u0014J\u0006\u0010'\u001a\u00020\u000bJ\u0006\u0010(\u001a\u00020\rJ\u0006\u0010)\u001a\u00020\u000fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006*"}, d2={"Lde/confinitum/pdfview/base/RenderService;", "Ljavafx/concurrent/Service;", "Ljavafx/scene/image/Image;", "pdfViewSkin", "Lde/confinitum/pdfview/skin/PDFViewSkin;", "thumbnailRenderer", "", "exec", "Ljava/util/concurrent/Executor;", "(Lde/confinitum/pdfview/skin/PDFViewSkin;ZLjava/util/concurrent/Executor;)V", "_page", "Ljavafx/beans/property/IntegerProperty;", "_rotation", "Ljavafx/beans/property/DoubleProperty;", "_scale", "Ljavafx/beans/property/FloatProperty;", "value", "", "page", "getPage", "()I", "setPage", "(I)V", "getPdfViewSkin", "()Lde/confinitum/pdfview/skin/PDFViewSkin;", "", "rotation", "getRotation", "()D", "setRotation", "(D)V", "scale", "", "getScale", "()F", "getThumbnailRenderer", "()Z", "createTask", "Ljavafx/concurrent/Task;", "pageProperty", "rotationProperty", "scaleProperty", "kpdfx"})
public final class RenderService
extends Service<Image> {
    @NotNull
    private final PDFViewSkin pdfViewSkin;
    private final boolean thumbnailRenderer;
    @NotNull
    private final FloatProperty _scale;
    @NotNull
    private final DoubleProperty _rotation;
    @NotNull
    private final IntegerProperty _page;

    public RenderService(@NotNull PDFViewSkin pdfViewSkin, boolean thumbnailRenderer, @NotNull Executor exec) {
        Intrinsics.checkNotNullParameter((Object)((Object)pdfViewSkin), (String)"pdfViewSkin");
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        this.pdfViewSkin = pdfViewSkin;
        this.thumbnailRenderer = thumbnailRenderer;
        this._scale = (FloatProperty)new SimpleFloatProperty(1.0f);
        this._rotation = (DoubleProperty)new SimpleDoubleProperty(0.0);
        this._page = (IntegerProperty)new SimpleIntegerProperty(-1);
        this.setExecutor(exec);
        InvalidationListener restartListener = arg_0 -> RenderService._init_$lambda$0(this, arg_0);
        this.pageProperty().addListener(restartListener);
        this.scaleProperty().addListener(restartListener);
        this.rotationProperty().addListener(restartListener);
    }

    public /* synthetic */ RenderService(PDFViewSkin pDFViewSkin, boolean bl, Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            executor = ((PDFView)pDFViewSkin.getSkinnable()).getRenderExecutor();
        }
        this(pDFViewSkin, bl, executor);
    }

    @NotNull
    public final PDFViewSkin getPdfViewSkin() {
        return this.pdfViewSkin;
    }

    public final boolean getThumbnailRenderer() {
        return this.thumbnailRenderer;
    }

    @NotNull
    public final FloatProperty scaleProperty() {
        return this._scale;
    }

    public final float getScale() {
        return this._scale.get();
    }

    @NotNull
    public final DoubleProperty rotationProperty() {
        return this._rotation;
    }

    public final double getRotation() {
        return this._rotation.get();
    }

    public final void setRotation(double value) {
        this._rotation.set(value);
    }

    @NotNull
    public final IntegerProperty pageProperty() {
        return this._page;
    }

    public final int getPage() {
        return this._page.get();
    }

    public final void setPage(int value) {
        this._page.set(value);
    }

    @NotNull
    protected Task<Image> createTask() {
        return new RenderTask(this.pdfViewSkin, this.thumbnailRenderer, this.getPage(), this.getScale(), this.getRotation());
    }

    private static final void _init_$lambda$0(RenderService this$0, Observable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.restart();
    }
}

