/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.commons.updater;

import de.comhix.commons.updater.Updater;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0006\u001a\u00020\u0007\"\b\b\u0000\u0010\b*\u00020\u0001\"\u000e\b\u0001\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u0002H\b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\f0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u000f2\u0006\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0012R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/comhix/commons/updater/UpdaterInterface;", "", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "tryUpdate", "", "Info", "Version", "", "url", "", "currentVersion", "updateUrlProvider", "Ljava/util/function/Function;", "versionProvider", "autoUpdate", "(Ljava/lang/String;Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/function/Function;Z)Z", "updater"})
public final class UpdaterInterface {
    private static final Logger log;
    public static final UpdaterInterface INSTANCE;

    public final <Info, Version extends Comparable<? super Version>> boolean tryUpdate(@NotNull String url, @NotNull Info currentVersion, @NotNull Function<Info, String> updateUrlProvider, @NotNull Function<Info, Version> versionProvider, boolean autoUpdate) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(currentVersion, (String)"currentVersion");
        Intrinsics.checkNotNullParameter(updateUrlProvider, (String)"updateUrlProvider");
        Intrinsics.checkNotNullParameter(versionProvider, (String)"versionProvider");
        Updater<Info, Version> updater = Updater.Companion.create(url, currentVersion, updateUrlProvider, versionProvider);
        if (updater.hasUpdate()) {
            boolean doUpdate = autoUpdate;
            if (!autoUpdate) {
                if (!GraphicsEnvironment.isHeadless()) {
                    int confirmDialog = JOptionPane.showConfirmDialog(null, "Update available. Load it now?", "Update", 0);
                    switch (confirmDialog) {
                        case 0: {
                            doUpdate = true;
                            break;
                        }
                        case 1: {
                            log.fine("aborting update");
                            break;
                        }
                        default: {
                            log.fine("update dialog closed, stopping application");
                            System.exit(0);
                            break;
                        }
                    }
                } else {
                    log.info("Update found. Use update-mode if available or execute in graphic-mode.");
                }
            }
            if (doUpdate) {
                updater.doUpdate();
                return true;
            }
        }
        return false;
    }

    private UpdaterInterface() {
    }

    static {
        UpdaterInterface updaterInterface;
        INSTANCE = updaterInterface = new UpdaterInterface();
        log = Logger.getLogger(UpdaterInterface.class.getName());
    }
}

