package de.comhix.commons.updater;

import javax.swing.*;
import java.awt.*;
import java.io.IOException;
import java.util.function.Function;
import java.util.logging.Logger;

/**
 * @author Benjamin Beeker
 */
public class UpdaterInterface {
    private static final Logger log = Logger.getLogger(UpdaterInterface.class.getName());

    public static <Info, Version extends Comparable<Version>> boolean tryUpdate(String url,
                                                                                Info currentVersion,
                                                                                Function<Info, String> updateUrlProvider,
                                                                                Function<Info, Version> versionProvider,
                                                                                boolean autoUpdate) throws IOException {

        Updater<Info, Version> updater = Updater.create(url, currentVersion, updateUrlProvider, versionProvider);
        if (updater.hasUpdate()) {
            boolean doUpdate = autoUpdate;
            if (!autoUpdate) {
                if (!GraphicsEnvironment.isHeadless()) {
                    int confirmDialog = JOptionPane.showConfirmDialog(null, "Update available. Load it now?", "Update", JOptionPane.YES_NO_OPTION);
                    switch (confirmDialog) {
                        case JOptionPane.YES_OPTION:
                            doUpdate = true;
                            break;
                        case JOptionPane.NO_OPTION:
                            log.fine("aborting update");
                            break;
                        default:
                            log.fine("update dialog closed, stopping application");
                            System.exit(0);
                    }
                }
                else {
                    log.info("Update found. Use update-mode if available or execute in graphic-mode.");
                }
            }

            if (doUpdate) {
                updater.doUpdate();
                return true;
            }
        }
        return false;
    }
}
