/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.commons.updater;

import de.comhix.commons.updater.Updater;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class UpdaterInterface {
    private static final Logger log = Logger.getLogger(UpdaterInterface.class.getName());

    public static <Info, Version extends Comparable<Version>> boolean tryUpdate(String url, Info currentVersion, Function<Info, String> updateUrlProvider, Function<Info, Version> versionProvider, boolean autoUpdate) throws IOException {
        Updater<Info, Version> updater = Updater.create(url, currentVersion, updateUrlProvider, versionProvider);
        if (updater.hasUpdate()) {
            boolean doUpdate = autoUpdate;
            if (!autoUpdate) {
                if (!GraphicsEnvironment.isHeadless()) {
                    int confirmDialog = JOptionPane.showConfirmDialog(null, "Update available. Load it now?", "Update", 0);
                    switch (confirmDialog) {
                        case 0: {
                            doUpdate = true;
                            break;
                        }
                        case 1: {
                            log.fine("aborting update");
                            break;
                        }
                        default: {
                            log.fine("update dialog closed, stopping application");
                            System.exit(0);
                            break;
                        }
                    }
                } else {
                    log.info("Update found. Use update-mode if available or execute in graphic-mode.");
                }
            }
            if (doUpdate) {
                updater.doUpdate();
                return true;
            }
        }
        return false;
    }
}

