/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.commons.updater;

import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public class Updater<Info, Version extends Comparable<Version>> {
    private final String url;
    private final Function<Info, String> updateUrlProvider;
    private final Function<Info, Version> versionProvider;
    private final Info currentVersion;
    private Info info;

    private Updater(String url, Info currentVersion, Function<Info, String> updateUrlProvider, Function<Info, Version> versionProvider) {
        this.url = url;
        this.updateUrlProvider = updateUrlProvider;
        this.versionProvider = versionProvider;
        this.currentVersion = currentVersion;
    }

    public static <Info, Version extends Comparable<Version>> Updater<Info, Version> create(String url, Info currentVersion, Function<Info, String> updateUrlProvider, Function<Info, Version> versionProvider) {
        return new Updater<Info, Version>(url, currentVersion, updateUrlProvider, versionProvider);
    }

    InputStream loadInfo() throws IOException {
        OkHttpClient client = new OkHttpClient.Builder().build();
        Response response = client.newCall(new Request.Builder().url(this.url).build()).execute();
        return response.body().byteStream();
    }

    private Info getInfo() throws IOException {
        if (this.info == null) {
            this.info = new GsonBuilder().create().fromJson((Reader)new InputStreamReader(this.loadInfo()), this.currentVersion.getClass());
        }
        return this.info;
    }

    public boolean hasUpdate() throws IOException {
        Info info = this.getInfo();
        return ((Comparable)this.versionProvider.apply(this.currentVersion)).compareTo(this.versionProvider.apply(info)) < 0;
    }

    public void doUpdate() throws IOException {
        OkHttpClient client = new OkHttpClient.Builder().build();
        Response response = client.newCall(new Request.Builder().url(this.updateUrlProvider.apply(this.info)).build()).execute();
        try (BufferedSink output = Okio.buffer((Sink)Okio.sink((File)new File("update.zip")));){
            output.writeAll(Okio.source((InputStream)response.body().byteStream()));
        }
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream("update.zip"));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            int len;
            String fileName = zipEntry.getName();
            File newFile = new File(fileName);
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        new File("update.zip").deleteOnExit();
    }
}

