/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.database.config;

import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/comhix/database/config/DatabaseModule;", "Lcom/google/inject/AbstractModule;", "host", "", "port", "", "dbName", "user", "password", "authDatabase", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "configure", "", "Companion", "mongodb"})
public final class DatabaseModule
extends AbstractModule {
    private final String host;
    private final int port;
    private final String dbName;
    private final String user;
    private final String password;
    private final String authDatabase;
    @NotNull
    public static final String DEFAULT_AUTH_DB = "admin";
    public static final Companion Companion = new Companion(null);

    protected void configure() {
        String string = this.password;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string2.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        MongoCredential credential = MongoCredential.createCredential((String)this.user, (String)this.authDatabase, (char[])cArray);
        MongoClient mongo = new MongoClient(new ServerAddress(this.host, this.port), (List)Lists.newArrayList((Object[])new MongoCredential[]{credential}));
        Datastore datastore = new Morphia().createDatastore(mongo, this.dbName);
        this.bind(Datastore.class).toInstance((Object)datastore);
    }

    @JvmOverloads
    public DatabaseModule(@NotNull String host, int port, @NotNull String dbName, @NotNull String user, @NotNull String password, @NotNull String authDatabase) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)authDatabase, (String)"authDatabase");
        this.host = host;
        this.port = port;
        this.dbName = dbName;
        this.user = user;
        this.password = password;
        this.authDatabase = authDatabase;
    }

    public /* synthetic */ DatabaseModule(String string, int n, String string2, String string3, String string4, String string5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            string5 = DEFAULT_AUTH_DB;
        }
        this(string, n, string2, string3, string4, string5);
    }

    @JvmOverloads
    public DatabaseModule(@NotNull String host, int port, @NotNull String dbName, @NotNull String user, @NotNull String password) {
        this(host, port, dbName, user, password, null, 32, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lde/comhix/database/config/DatabaseModule$Companion;", "", "()V", "DEFAULT_AUTH_DB", "", "mongodb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

