package de.comhix.database.dao

import de.comhix.database.objects.DatabaseObject

/**
 * @author Benjamin Beeker
 */
interface SimpleDao<ObjectBase : DatabaseObject> {
    suspend fun <Type : ObjectBase> get(id: String, typeClass: Class<Type>): Type?
    suspend fun <Type : ObjectBase> save(instance: Type): Type
    suspend fun <Type : ObjectBase> delete(id: String, typeClass: Class<Type>)
    suspend fun <Type : ObjectBase> query(typeClass: Class<Type>): Query<Type>
}