/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.database.dao;

import com.mongodb.WriteResult;
import de.comhix.database.dao.Query;
import de.comhix.database.dao.SimpleDao;
import de.comhix.database.objects.DatabaseObject;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Key;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J1\u0010\u0006\u001a\u00020\u0007\"\b\b\u0000\u0010\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ3\u0010\u000e\u001a\u0004\u0018\u0001H\b\"\b\b\u0000\u0010\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ/\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\b0\u0010\"\b\b\u0000\u0010\b*\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J#\u0010\u0012\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\u00022\u0006\u0010\u0013\u001a\u0002H\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lde/comhix/database/dao/BaseDao;", "Lde/comhix/database/dao/SimpleDao;", "Lde/comhix/database/objects/DatabaseObject;", "datastore", "Lorg/mongodb/morphia/Datastore;", "(Lorg/mongodb/morphia/Datastore;)V", "delete", "", "Type", "id", "", "typeClass", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "get", "query", "Lde/comhix/database/dao/Query;", "(Ljava/lang/Class;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "save", "instance", "(Lde/comhix/database/objects/DatabaseObject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "mongodb"})
public final class BaseDao
implements SimpleDao<DatabaseObject> {
    private final Datastore datastore;

    @Override
    @Nullable
    public <Type extends DatabaseObject> Object get(@NotNull String id, @NotNull Class<Type> typeClass, @NotNull Continuation<? super Type> $completion) {
        return this.datastore.get(typeClass, (Object)id);
    }

    @Override
    @Nullable
    public <Type extends DatabaseObject> Object save(@NotNull Type instance, @NotNull Continuation<? super Type> $completion) {
        Key key = this.datastore.save(instance);
        Class<?> clazz = instance.getClass();
        if (clazz == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<Type>");
        }
        Object object = this.datastore.getByKey(clazz, key);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"datastore.getByKey(insta\u2026java as Class<Type>, key)");
        return object;
    }

    @Override
    @Nullable
    public <Type extends DatabaseObject> Object delete(@NotNull String id, @NotNull Class<Type> typeClass, @NotNull Continuation<? super Unit> $completion) {
        WriteResult writeResult = this.datastore.delete(typeClass, (Object)id);
        if (writeResult == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return writeResult;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public <Type extends DatabaseObject> Object query(@NotNull Class<Type> typeClass, @NotNull Continuation<? super Query<Type>> $completion) {
        return new Query<Type>(typeClass, this.datastore);
    }

    @Inject
    public BaseDao(@NotNull Datastore datastore) {
        Intrinsics.checkNotNullParameter((Object)datastore, (String)"datastore");
        this.datastore = datastore;
    }
}

