package de.comhix.database.dao.test

import com.google.common.collect.Lists
import de.comhix.database.dao.Query
import de.comhix.database.objects.QueryResult
import io.reactivex.Maybe
import io.reactivex.Single

/**
 * @author Benjamin Beeker
 */
class MockQuery<Type> @JvmOverloads constructor(private val data: Collection<Type> = Lists.newArrayList()) : Query<Type>() {
    constructor(vararg data: Type) : this(Lists.newArrayList(*data)) {}

    override fun <AllowedValueType> with(field: String?, operation: Operation<AllowedValueType>, value: AllowedValueType): Query<Type>? {
        return this
    }

    override fun limit(limit: Int): Query<Type>? {
        return this
    }

    override fun skip(skip: Int): Query<Type>? {
        return this
    }

    override fun order(field: String?): Query<Type>? {
        return this
    }

    override fun query(): Single<QueryResult<Type>> {
        return Single.just(QueryResult(Lists.newArrayList(data)))
    }

    override fun find(): Maybe<Type> {
        return if (data.isEmpty()) Maybe.empty() else Maybe.just(data.iterator().next())
    }
}