package de.comhix.database.dao

import de.comhix.database.objects.UserDatabaseObject
import io.reactivex.Completable
import io.reactivex.Maybe
import io.reactivex.Single

/**
 * @author Benjamin Beeker
 */
class TypeUserDao<Type : UserDatabaseObject>(private val userDao: UserDao, private val typeClass: Class<Type>)
    : SimpleTypeDao<Type> {
    override operator fun get(id: String): Maybe<Type> {
        return userDao[id, typeClass]
    }

    override fun save(`object`: Type): Single<Type> {
        return userDao.save(`object`)
    }

    override fun delete(id: String): Completable {
        return userDao.delete(id, typeClass)
    }

    override fun query(): Query<Type> {
        return userDao.query(typeClass)
    }
}