package de.comhix.database.dao

import de.comhix.database.objects.DatabaseObject
import io.reactivex.Completable
import io.reactivex.Maybe
import io.reactivex.Single

/**
 * @author Benjamin Beeker
 */
interface SimpleTypeDao<ObjectBase : DatabaseObject> {
    operator fun get(id: String): Maybe<ObjectBase>
    fun save(`object`: ObjectBase): Single<ObjectBase>
    fun delete(id: String): Completable
    fun query(): Query<ObjectBase>
}