package de.comhix.database.dao

import de.comhix.database.objects.DatabaseObject
import io.reactivex.Completable
import io.reactivex.Maybe
import io.reactivex.Single

/**
 * @author Benjamin Beeker
 */
interface SimpleDao<ObjectBase : DatabaseObject> {
    operator fun <Type : ObjectBase> get(id: String, typeClass: Class<Type>): Maybe<Type>
    fun <Type : ObjectBase> save(instance: Type): Single<Type>
    fun <Type : ObjectBase> delete(id: String, typeClass: Class<Type>): Completable
    fun <Type : ObjectBase> query(typeClass: Class<Type>): Query<Type>
}