package de.comhix.database.dao

import de.comhix.database.objects.DatabaseObject
import io.reactivex.Completable
import io.reactivex.Maybe
import io.reactivex.Single
import javax.inject.Inject
import javax.inject.Named

/**
 * @author Benjamin Beeker
 */
class TypeDao<Type : DatabaseObject> @Inject constructor(private val baseDao: BaseDao,
                                                         @Named(NAMED_TYPE_INJECT_PARAM) private val typeClass: Class<Type>)
    : SimpleTypeDao<Type> {
    override operator fun get(id: String): Maybe<Type> {
        return baseDao.get(id, typeClass)
    }

    override fun save(`object`: Type): Single<Type> {
        return baseDao.save(`object`)
    }

    override fun delete(id: String): Completable {
        return baseDao.delete(id, typeClass)
    }

    override fun query(): Query<Type> {
        return baseDao.query(typeClass)
    }

    companion object {
        const val NAMED_TYPE_INJECT_PARAM = "NAMED_TYPE_INJECT_PARAM"
    }
}