/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.twitch.database.dao;

import de.comhix.twitch.database.objects.QueryResult;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.FindOptions;

public class Query<Type> {
    private final org.mongodb.morphia.query.Query<Type> query;
    private final FindOptions options = new FindOptions();

    protected Query() {
        this.query = null;
    }

    protected Query(Class<Type> typeClass, Datastore datastore) {
        this.query = datastore.createQuery(typeClass);
    }

    public <AllowedValueType> Query<Type> with(String field, Operation<AllowedValueType> operation, AllowedValueType value) {
        if (operation == Operation.EQ) {
            this.query.field(field).equal(value);
        } else if (operation == Operation.NEQ) {
            this.query.field(field).notEqual(value);
        } else if (operation == Operation.GT) {
            this.query.field(field).greaterThan(value);
        } else if (operation == Operation.GEQ) {
            this.query.field(field).greaterThanOrEq(value);
        } else if (operation == Operation.LT) {
            this.query.field(field).lessThan(value);
        } else if (operation == Operation.LEQ) {
            this.query.field(field).lessThanOrEq(value);
        } else if (operation == Operation.EXISTS) {
            if (((Boolean)value).booleanValue()) {
                this.query.field(field).exists();
            } else {
                this.query.field(field).doesNotExist();
            }
        } else if (operation == Operation.IN) {
            this.query.field(field).in((Iterable)value);
        } else if (operation == Operation.NOT_IN) {
            this.query.field(field).notIn((Iterable)value);
        } else if (operation == Operation.HAS) {
            this.query.field(field).hasThisOne(value);
        } else if (operation == Operation.HAS_ANY) {
            this.query.field(field).hasAnyOf((Iterable)value);
        } else if (operation == Operation.HAS_NONE) {
            this.query.field(field).hasNoneOf((Iterable)value);
        } else if (operation == Operation.HAS_ALL) {
            this.query.field(field).hasAllOf((Iterable)value);
        }
        return this;
    }

    public Query<Type> limit(int limit) {
        this.options.limit(limit);
        return this;
    }

    public Query<Type> skip(int skip) {
        this.options.skip(skip);
        return this;
    }

    public Query<Type> order(String field) {
        this.query.order(field);
        return this;
    }

    public Single<QueryResult<Type>> query() {
        return Observable.zip((ObservableSource)Observable.fromCallable(() -> this.query.asList(this.options)), (ObservableSource)Observable.fromCallable(() -> this.query.count()), QueryResult::new).firstOrError().subscribeOn(Schedulers.io());
    }

    public Maybe<Type> find() {
        this.limit(1);
        return this.query().flatMapMaybe(results -> {
            if (results.isEmpty()) {
                return Maybe.empty();
            }
            return Maybe.just((Object)results.get(0));
        });
    }

    public static class Operation<AllowedValueType> {
        public static final Operation<Object> EQ = new Operation();
        public static final Operation<Object> NEQ = new Operation();
        public static final Operation<Comparable> GT = new Operation();
        public static final Operation<Comparable> GEQ = new Operation();
        public static final Operation<Comparable> LT = new Operation();
        public static final Operation<Comparable> LEQ = new Operation();
        public static final Operation<Boolean> EXISTS = new Operation();
        public static final Operation<Iterable> IN = new Operation();
        public static final Operation<Iterable> NOT_IN = new Operation();
        public static final Operation<Object> HAS = new Operation();
        public static final Operation<Iterable> HAS_ANY = new Operation();
        public static final Operation<Iterable> HAS_NONE = new Operation();
        public static final Operation<Iterable> HAS_ALL = new Operation();

        private Operation() {
        }
    }
}

