package de.comhix.twitch.database.dao.test;

import de.comhix.twitch.database.dao.Query;
import de.comhix.twitch.database.objects.QueryResult;
import io.reactivex.Maybe;
import io.reactivex.Single;

import java.util.Collection;

import static com.google.common.collect.Lists.newArrayList;

/**
 * @author Benjamin Beeker
 */
public class MockQuery<Type> extends Query<Type> {

    private final Collection<Type> data;

    public MockQuery() {
        this(newArrayList());
    }

    public MockQuery(Type... data) {
        this(newArrayList(data));
    }

    public MockQuery(Collection<Type> data) {
        this.data = data;
    }

    @Override
    public <AllowedValueType> Query<Type> with(String field, Operation<AllowedValueType> operation, AllowedValueType value) {
        return this;
    }

    @Override
    public Query<Type> limit(int limit) {
        return this;
    }

    @Override
    public Query<Type> skip(int skip) {
        return this;
    }

    @Override
    public Query<Type> order(String field) {
        return this;
    }

    @Override
    public Single<QueryResult<Type>> query() {
        return Single.just(new QueryResult<>(newArrayList(data)));
    }

    @Override
    public Maybe<Type> find() {
        return data.isEmpty() ? Maybe.empty() : Maybe.just(data.iterator().next());
    }
}
