package de.comhix.twitch.database.dao;

import de.comhix.twitch.database.objects.DatabaseObject;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;

/**
 * @author Benjamin Beeker
 */
public interface SimpleTypeDao<ObjectBase extends DatabaseObject> {
    <Type extends ObjectBase> Maybe<Type> get(String id);

    <Type extends ObjectBase> Single<Type> save(Type object);

    Completable delete(String id);

    <Type extends ObjectBase> Query<Type> query();
}
