/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.twitch.database.dao;

import de.comhix.twitch.database.dao.BaseDao;
import de.comhix.twitch.database.dao.Query;
import de.comhix.twitch.database.dao.SimpleTypeDao;
import de.comhix.twitch.database.objects.DatabaseObject;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import javax.inject.Inject;
import javax.inject.Named;

public class TypeDao<Type extends DatabaseObject>
implements SimpleTypeDao<Type> {
    public static final String NAMED_TYPE_INJECT_PARAM = "NAMED_TYPE_INJECT_PARAM";
    private final BaseDao baseDao;
    private final Class<Type> typeClass;

    @Inject
    public TypeDao(BaseDao baseDao, @Named(value="NAMED_TYPE_INJECT_PARAM") Class<Type> typeClass) {
        this.baseDao = baseDao;
        this.typeClass = typeClass;
    }

    @Override
    public Maybe<Type> get(String id) {
        return this.baseDao.get(id, this.typeClass);
    }

    @Override
    public <MType extends Type> Single<MType> save(MType object) {
        return this.baseDao.save(object);
    }

    @Override
    public Completable delete(String id) {
        return this.baseDao.delete(id, this.typeClass);
    }

    @Override
    public Query<Type> query() {
        return this.baseDao.query(this.typeClass);
    }
}

