package de.comhix.twitch.database.config;

import com.google.inject.AbstractModule;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;

import static com.google.common.collect.Lists.newArrayList;

/**
 * @author Benjamin Beeker
 */
public class DatabaseModule extends AbstractModule {
    public static final String DEFAULT_AUTH_DB = "admin";
    private final String host;
    private final int port;
    private final String dbName;
    private final String user;
    private final String password;
    private final String authDatabase;

    public DatabaseModule(String host, int port, String dbName) {
        this(host, port, dbName, null, null);
    }

    public DatabaseModule(String host, int port, String dbName, String user, String password) {
        this(host, port, dbName, user, password, DEFAULT_AUTH_DB);
    }

    public DatabaseModule(String host, int port, String dbName, String user, String password, String authDatabase) {
        this.host = host;
        this.port = port;
        this.dbName = dbName;
        this.user = user;
        this.password = password;
        this.authDatabase = authDatabase;
    }

    @Override
    protected void configure() {
        MongoCredential credential = MongoCredential.createCredential(user, authDatabase, password.toCharArray());
        MongoClient mongo = new MongoClient(new ServerAddress(host, port), newArrayList(credential));
        Datastore datastore = new Morphia().createDatastore(mongo, dbName);
        bind(Datastore.class).toInstance(datastore);
    }
}
