/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.twitch.database.dao;

import com.google.inject.Inject;
import de.comhix.twitch.database.dao.BaseDao;
import de.comhix.twitch.database.dao.Query;
import de.comhix.twitch.database.dao.SimpleDao;
import de.comhix.twitch.database.objects.UserDatabaseObject;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import java.util.Objects;
import javax.inject.Named;
import org.bson.types.ObjectId;

public class UserDao
implements SimpleDao<UserDatabaseObject> {
    public static final String USER_INJECT = "User_Inject";
    private final BaseDao baseDao;
    private final String user;

    @Inject
    public UserDao(BaseDao baseDao, @Named(value="User_Inject") String user) {
        this.baseDao = baseDao;
        this.user = user;
    }

    @Override
    public <Type extends UserDatabaseObject> Maybe<Type> get(String id, Class<Type> typeClass) {
        return this.baseDao.get(id, typeClass).flatMap(object -> {
            if (Objects.equals(object.user, this.user)) {
                return Maybe.just((Object)object);
            }
            return Maybe.empty();
        });
    }

    @Override
    public <Type extends UserDatabaseObject> Single<Type> save(Type object) {
        return this.baseDao.get(object.id, object.getClass()).toSingle(object).flatMap(foundObject -> {
            if (!Objects.equals(foundObject.user, this.user)) {
                object.id = new ObjectId().toString();
                object.version = 0L;
            }
            object.user = this.user;
            return this.baseDao.save(object);
        });
    }

    @Override
    public <Type extends UserDatabaseObject> Completable delete(String id, Class<Type> typeClass) {
        return this.baseDao.get(id, typeClass).flatMapCompletable(object -> {
            if (!Objects.equals(object.user, this.user)) {
                return Completable.complete();
            }
            return this.baseDao.delete(id, typeClass);
        });
    }

    @Override
    public <Type extends UserDatabaseObject> Query<Type> query(Class<Type> typeClass) {
        return this.baseDao.query(typeClass).with("user", Query.Operation.EQ, this.user);
    }
}

