/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.twitch.database.dao;

import de.comhix.twitch.database.dao.Query;
import de.comhix.twitch.database.dao.SimpleDao;
import de.comhix.twitch.database.objects.DatabaseObject;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import javax.inject.Inject;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Key;

public class BaseDao
implements SimpleDao<DatabaseObject> {
    private final Datastore datastore;

    @Inject
    public BaseDao(Datastore datastore) {
        this.datastore = datastore;
    }

    @Override
    public <Type extends DatabaseObject> Maybe<Type> get(String id, Class<Type> typeClass) {
        return Maybe.fromCallable(() -> (DatabaseObject)this.datastore.get(typeClass, (Object)id)).subscribeOn(Schedulers.io());
    }

    @Override
    public <Type extends DatabaseObject> Single<Type> save(Type object) {
        return Single.fromCallable(() -> {
            Key key = this.datastore.save((Object)object);
            return (DatabaseObject)this.datastore.getByKey(object.getClass(), key);
        }).subscribeOn(Schedulers.io());
    }

    @Override
    public <Type extends DatabaseObject> Completable delete(String id, Class<Type> typeClass) {
        return Completable.fromCallable(() -> this.datastore.delete(typeClass, (Object)id)).subscribeOn(Schedulers.io());
    }

    @Override
    public <Type extends DatabaseObject> Query<Type> query(Class<Type> typeClass) {
        return new Query<Type>(typeClass, this.datastore);
    }
}

