/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.twitch.database.config;

import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.List;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;

public class DatabaseModule
extends AbstractModule {
    public static final String DEFAULT_AUTH_DB = "admin";
    private final String host;
    private final int port;
    private final String dbName;
    private final String user;
    private final String password;
    private final String authDatabase;

    public DatabaseModule(String host, int port, String dbName) {
        this(host, port, dbName, null, null);
    }

    public DatabaseModule(String host, int port, String dbName, String user, String password) {
        this(host, port, dbName, user, password, DEFAULT_AUTH_DB);
    }

    public DatabaseModule(String host, int port, String dbName, String user, String password, String authDatabase) {
        this.host = host;
        this.port = port;
        this.dbName = dbName;
        this.user = user;
        this.password = password;
        this.authDatabase = authDatabase;
    }

    protected void configure() {
        MongoCredential credential = MongoCredential.createCredential((String)this.user, (String)this.authDatabase, (char[])this.password.toCharArray());
        MongoClient mongo = new MongoClient(new ServerAddress(this.host, this.port), (List)Lists.newArrayList((Object[])new MongoCredential[]{credential}));
        Datastore datastore = new Morphia().createDatastore(mongo, this.dbName);
        this.bind(Datastore.class).toInstance((Object)datastore);
    }
}

