/*
 * Decompiled with CFR 0.152.
 */
package de.comhix.twitch.database.dao;

import de.comhix.twitch.database.TestDatabaseModule;
import de.comhix.twitch.database.dao.BaseDao;
import de.comhix.twitch.database.dao.UserDao;
import de.comhix.twitch.database.objects.TestObject;
import de.comhix.twitch.database.objects.UserDatabaseObject;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestDatabaseModule.class})
public class UserDaoTest {
    private static final Logger log = LoggerFactory.getLogger(UserDaoTest.class);
    @Inject
    private Datastore datastore;
    private String userA;
    private String userB;
    private UserDao userADao;
    private UserDao userBDao;

    @BeforeMethod
    public void setup() {
        this.userA = new ObjectId().toString();
        this.userB = new ObjectId().toString();
        BaseDao baseDao = new BaseDao(this.datastore);
        this.userADao = new UserDao(baseDao, this.userA);
        this.userBDao = new UserDao(baseDao, this.userB);
    }

    @Test(timeOut=30000L)
    public void testSave_own() throws Exception {
        log.info("testSave_own");
        TestObject object = new TestObject();
        TestObject saved = (TestObject)((Object)this.userADao.save((UserDatabaseObject)object).blockingGet());
        Assertions.assertThat((String)saved.user).isEqualTo((Object)this.userA);
    }

    @Test
    public void testSave_doNotOverwriteDifferentUser() throws Exception {
        log.info("testSave_doNotOverwriteDifferentUser");
        TestObject object = new TestObject();
        TestObject object2 = (TestObject)((Object)this.userBDao.save((UserDatabaseObject)object).blockingGet());
        TestObject saved = (TestObject)((Object)this.userADao.save((UserDatabaseObject)object2).blockingGet());
        Assertions.assertThat((String)saved.user).isEqualTo((Object)this.userA);
        TestObject bObject = (TestObject)((Object)this.userBDao.get(object.id, TestObject.class).blockingGet());
        Assertions.assertThat((String)bObject.user).isEqualTo((Object)this.userB);
    }

    @Test(timeOut=30000L)
    public void testSave_differentUser() throws Exception {
        log.info("testSave_differentUser");
        TestObject object = new TestObject();
        object.user = this.userB;
        TestObject saved = (TestObject)((Object)this.userADao.save((UserDatabaseObject)object).blockingGet());
        Assertions.assertThat((String)saved.user).isEqualTo((Object)this.userA);
    }

    @Test(timeOut=30000L)
    public void testGet_own() throws Exception {
        log.info("testGet_own");
        TestObject object = new TestObject();
        this.userADao.save((UserDatabaseObject)object).blockingGet();
        TestObject saved = (TestObject)((Object)this.userADao.get(object.id, TestObject.class).blockingGet());
        Boolean isEmpty = (Boolean)this.userADao.get(object.id, TestObject.class).isEmpty().blockingGet();
        Assertions.assertThat((String)saved.user).isEqualTo((Object)this.userA);
        Assertions.assertThat((Boolean)isEmpty).isFalse();
    }

    @Test(timeOut=30000L)
    public void testGet_notExisting() throws Exception {
        log.info("testGet_notExisting");
        Boolean isEmpty = (Boolean)this.userADao.get("something", TestObject.class).isEmpty().blockingGet();
        Assertions.assertThat((Boolean)isEmpty).isTrue();
    }

    @Test(timeOut=30000L)
    public void testGet_differentUser() throws Exception {
        log.info("testGet_differentUser");
        TestObject object = new TestObject();
        this.userADao.save((UserDatabaseObject)object).blockingGet();
        Boolean isEmpty = (Boolean)this.userBDao.get(object.id, TestObject.class).isEmpty().blockingGet();
        Assertions.assertThat((Boolean)isEmpty).isTrue();
    }

    @Test(timeOut=30000L)
    public void testDelete_own() throws Exception {
        log.info("testDelete_own");
        TestObject object = new TestObject();
        this.userADao.save((UserDatabaseObject)object).blockingGet();
        this.userADao.delete(object.id, TestObject.class).blockingAwait();
        Boolean isEmpty = (Boolean)this.userADao.get(object.id, TestObject.class).isEmpty().blockingGet();
        Assertions.assertThat((Boolean)isEmpty).isTrue();
    }

    @Test(timeOut=30000L)
    public void testDelete_notExisting() throws Exception {
        log.info("testDelete_notExisting");
        this.userADao.delete("something", TestObject.class).blockingAwait();
        Boolean isEmpty = (Boolean)this.userADao.get("something", TestObject.class).isEmpty().blockingGet();
        Assertions.assertThat((Boolean)isEmpty).isTrue();
    }

    @Test(timeOut=30000L)
    public void testDelete_differentUser() throws Exception {
        log.info("testDelete_differentUser");
        TestObject object = new TestObject();
        this.userADao.save((UserDatabaseObject)object).blockingGet();
        this.userBDao.delete(object.id, TestObject.class).blockingAwait();
        Boolean isEmpty = (Boolean)this.userADao.get(object.id, TestObject.class).isEmpty().blockingGet();
        Assertions.assertThat((Boolean)isEmpty).isFalse();
    }
}

